#include <lua.hpp>
#include "luabind/luabind.hpp"
#include <memory>
#include <boost/utility.hpp>

// LuaInterpreter.cppからのみインクルードする

namespace mof
{
namespace script
{
	class CommandSet;

	class lua_state : boost::noncopyable
	{
	public:
		~lua_state();
		void bind(std::shared_ptr<mof::script::CommandSet> commands);
		lua_State* raw_lua() const;
		std::shared_ptr<mof::script::CommandSet>& const command_set() const;
		static lua_state& instance(); 
	private:
		lua_state();// singleton
		static lua_state singleton_lua;
		struct Impl;
		std::unique_ptr<Impl> impl_;
	};

}// script
}// mof
