#pragma once
#include <mof/Color.hpp>
#include <lua.hpp>
#include <vector>
#include <stdexcept>
#include <mof/streams.hpp>


// seq_factory
namespace mof
{
namespace script
{
	template <typename T>
	class seq_parser 
	{
	public:
		typedef typename KeyFrameAnimation<T>::KeyFrame key_frame;
//{{{ parse
		typename Manipulator<T>::ptr parse(lua_State* l, size_t offset) const
		{
			std::vector<typename KeyFrameAnimation<T>::KeyFrame> v;

			lua_pushnil(l);
			while (lua_next(l, offset) != 0) {
				if (lua_isnumber(l, -2)) {
					v.push_back(pop_key_frame(l));
				}
				else if (lua_isstring(l, -2)) {
					// loopなど TODO
				}
				lua_pop(l, 1);// pop the value
			}
			return make_manip(v);
		}
//}}}
	private:
//{{{ pop_key_frame
		key_frame pop_key_frame(lua_State* l) const
		{
		}
//}}}
//{{{ make_manip
		typename Manipulator<T>::ptr make_manip(const std::vector<key_frame>& v) const
		{
		}
//}}}
	};
//{{{ <Color4f>
		seq_parser<Color4f>::key_frame seq_parser<Color4f>::pop_key_frame(lua_State* l) const
		{
			FrameNumber frame = lua_tointeger(l, -2);
			double values[4];
			int index = 0;
			lua_pushnil(l);
			for (; lua_next(l, -2) && index < 4; ++index) {
				values[index] = lua_tonumber(l, -1);
				lua_pop(l, 1);
			}
			if (index == 4) {
				return key_frame(frame, Color4f(values[0], values[1], values[2], values[3]));// ARGB
			}
			else if (index == 3) {
				return key_frame(frame, Color4f(values[0], values[1], values[2]));// RGB
			}
			else throw std::runtime_error("too few color parameters");
		}

		Manipulator<Color4f>::ptr seq_parser<Color4f>::make_manip(const std::vector<seq_parser<Color4f>::key_frame>& v) const
		{
			return makeKeyFrameAnimationHandler<Color4f>(v.front(), v.back());
		}
	//};
//}}}
//{{{ <Vector2D>
		seq_parser<Vector2D>::key_frame seq_parser<Vector2D>::pop_key_frame(lua_State* l) const
		{
			FrameNumber frame = lua_tointeger(l, -2);
			double values[2];
			int index = 0;
			lua_pushnil(l);
			for (; lua_next(l, -2) && index < 2; ++index) {
				values[index] = lua_tonumber(l, -1);
				lua_pop(l, 1);
			}
			if (index == 2) {
				return key_frame(frame, Vector2D(static_cast<float>(values[0]), static_cast<float>(values[1])));
			}
			else throw std::runtime_error("too few position2D parameters");
		}

		Manipulator<Vector2D>::ptr seq_parser<Vector2D>::make_manip(const std::vector<seq_parser<Vector2D>::key_frame>& v) const
		{
			return makeKeyFrameAnimationHandler<Vector2D>(v.front(), v.back());
		}
	//};
//}}}
//{{{ <Vector3D>
		seq_parser<Vector3D>::key_frame seq_parser<Vector3D>::pop_key_frame(lua_State* l) const
		{
			FrameNumber frame = lua_tointeger(l, -2);
			float values[3];
			int index = 0;
			lua_pushnil(l);
			for (; lua_next(l, -2) && index < 3; ++index) {
				values[index] = static_cast<float>(lua_tonumber(l, -1));
				lua_pop(l, 1);
			}
			if (index == 3) {
				return key_frame(frame, Vector3D(values[0], values[1], values[2]));
			}
			else throw std::runtime_error("too few position3D parameters");
		}

		Manipulator<Vector3D>::ptr seq_parser<Vector3D>::make_manip(const std::vector<seq_parser<Vector3D>::key_frame>& v) const
		{
			return makeKeyFrameAnimationHandler<Vector3D>(v.front(), v.back());
		}
	//};
//}}}
}// namespace script
}// namespace mof

