#pragma once
#include <stdio.h>
#include "mof/sound/SoundFile.hpp"
#include <vorbis/vorbisfile.h>
#include <mof/tstring.hpp>

namespace mof{
	class OggVorbisFile : public SoundFile
	{
		FILE* m_fp;
		OggVorbis_File m_vorbisFile;
		WAVEFORMATEX* m_pFormat;
		vorbis_info* m_vorbisInfo;

	public:
		OggVorbisFile(void);
		virtual ~OggVorbisFile(void);

		virtual bool open(const mof::tstring& filename);
		virtual bool close();
		virtual long read( BYTE* pBuffer1, long bufferSize1 , BYTE* pBuffer2 , long bufferSize2 );
		virtual long getSize();
		virtual bool resetFile();
		virtual WAVEFORMATEX* getFormat();
	};

};
