#pragma once
#include "mof/stream/utilities.hpp"

namespace mof
{
	typedef TypeStream<mof::real, Multiply<mof::real>> volume_stream;
	typedef TypeStream<mof::real, Overwrite<mof::real>> frequency_stream;

namespace sound
{

    class component_sound
    {
    public:
        virtual ~component_sound(){}

        const mof::volume_stream& volume_stream() const { return volume_stream_; }
		mof::volume_stream& volume_stream() { return volume_stream_; }

        const mof::frequency_stream& frequency_stream() const { return frequency_stream_; }
		mof::frequency_stream& frequency_stream() { return frequency_stream_; }
        
    protected:
		mof::volume_stream volume_stream_;///< 0 - 1.0
		mof::frequency_stream frequency_stream_;///< 0 -  

        component_sound()
        : 
            volume_stream_(makeConstantHandler(1.0f)),
            frequency_stream_(makeConstantHandler(1.0f)) 
        {}
        
        component_sound(mof::real volume, mof::real frequency)
        : 
            volume_stream_(makeConstantHandler(volume)),
            frequency_stream_(makeConstantHandler(frequency))
        {}

    };

}// namespace sound 
}// namespace mof
