#pragma once
#include <mof/stream/Reference.hpp>
#include <mof/stream/Offset.hpp>
#include <mof/stream/TypeStream.hpp>
#include <vector>

namespace mof
{
//{{{ ReferenceWrapper
    template<typename T>
    class ReferenceWrapper
    {
    public:
    
        typename Reference<T>::Handler makeRef(const typename Manipulator<T>::Handler& body)
        {
            m_list.push_back(makeReferenceHandler(body));
            return m_list.back();
        }
        
        typename Reference<T>::Handler makeRef(const T& body)
        {
            m_list.push_back(makeReferenceHandler<T>(makeConstantHandler(body)));
            return m_list.back();
        }


        void replace(int index , const typename Manipulator<T>::Handler& body)
        {
            m_list[index]->replace(body);
            //m_list[index]->replace(makeOffsetHandler(body , -1 * (int)m_stream.getCurrentFrameNumber()));
        }
        
        void replace(int index , const T& body)
        {
            m_list[index]->replace(makeConstantHandler(body));
            //m_list[index]->replace(makeOffsetHandler(makeConstantHandler(body) , -1 * (int)m_stream.getCurrentFrameNumber()));
        }

    	template<typename T, typename K>
        void replace(int index , const TypeStream<T, K>& stream , const typename Manipulator<T>::Handler& body)
        {
            m_list[index]->replace(makeOffsetHandler<T>(body , -1 * stream.getCurrentFrameNumber()));
        }
        

        typename Reference<T>::Handler getRef(int index) const
        {
            return m_list[index];
        }

    private:
        std::vector<typename Reference<T>::Handler> m_list;
    };
//}}}
} // namespace mof

