#pragma once
#define _USE_MATH_DEFINES
#include <math.h>
#include <boost/foreach.hpp>
#define foreach BOOST_FOREACH 

namespace mof{
    
    inline float deg2rad( float deg )
    {
        return deg / 180.0f * static_cast<float>(M_PI);
    }

    inline float rad2deg( float rad )
    {
        return rad / static_cast<float>(M_PI) * 180.0f;
    }

    template< typename T , int N >
    int lengthOf( T (&)[N] )
    {
        return N;
    }
    
    template< typename T , int N >
    T& lastOf( T(&arr)[N] )
    {
        return arr[N-1];
    }

    template< typename T >
    void safe_delete( T* (&p) )
    {
        delete p;
        p = NULL;
    }

    template< typename T >
    void safe_delete_array( T* (&p) )
    {
        delete[] p;
        p = NULL;
    }

    inline int rotation_mod(int a , unsigned int b)
    {
        return a >= 0 
            ? a % b 
            : b - (-a % b);
    }



} // namespace mof

