#pragma once
#include <memory>
#include <boost/utility.hpp>
#include <memory>
#include "mof/tstring.hpp"
#include <mof/stream/Manipulator.hpp>
#include <mof/Vector2D.hpp>
#include <mof/Color.hpp>
#include <mof/widget/WidgetView.hpp>

namespace mof
{
namespace widget
{
    struct Page;

    class AbstractTextCompiler : boost::noncopyable
    {
    public:
		enum BehaviorTarget
		{
			PAGE_OPEN,
			PAGE_CLOSE,
		};

        virtual ~AbstractTextCompiler(){}
        virtual std::auto_ptr<mof::widget::Page> compile(const mof::tstring& text) = 0;// deprecate
		virtual std::auto_ptr<mof::widget::WidgetView> compile_d(const mof::tstring& text) = 0; // {compile
		virtual void setBehaviorOnPosition(BehaviorTarget target, mof::Manipulator<mof::Vector2D>::Handler position, FrameNumber period) = 0;
		virtual void setBehaviorOnColor(BehaviorTarget target, mof::Manipulator<mof::Color4f>::Handler color, FrameNumber period) = 0;

    };//class AbstractTextCompiler

}// namespace widget
}// namespace mof
