#pragma once
#include <memory>
#include <vector>
#include <mof/tstring.hpp>

namespace mof
{
namespace widget
{
    class WidgetView;

    /**
     * @note 継承禁止 , immutable
     */
    struct Page 
    {
    private:
        std::shared_ptr<mof::widget::WidgetView> view_;
        tstring text_;
     
    public:
        Page
        (
            const std::shared_ptr<mof::widget::WidgetView>& view ,
            const tstring& text
        ) : view_(view) , text_(text)
        {}

        ~Page(){};

        const std::shared_ptr<mof::widget::WidgetView>& view() const { return view_; }
        const tstring& text() const { return text_; }
      
    };// struct Page

}// namespace widget
}// namespace mof
