#pragma once
#include <mof/math/basic_matrix.hpp>

namespace mof
{
namespace math
{
	class vector3;

	/**
	 * @brief 3æ¬¡ååæ¬¡åº§æ¨å¤æè¡åã¯ã©ã¹
	 */
	class matrix3 : public basic_matrix<3, matrix3, vector3>
	{
	public:
//{{{ constructor
		/**
		 * @brief ããã©ã«ãã³ã³ã¹ãã©ã¯ã¿
		 * @note  å¹çã®ããï¼åæåã¯è¡ãããªã
		 */
		matrix3()
		{
		}

		/**
		 * @brief æå®ããå¤ã§åæåããï¼
		 * @tparam     T   éååï¼operator[]ããªã¼ãã¼ã­ã¼ããã¦ãããã¨ï¼
		 * @param[in]  arr åæåç¨éå
		 */
		template <class T>
		explicit matrix3(const T& arr)
		{
			for (size_t i = 0; i < size(); ++i) {
				elements_[i] = arr[i];
			}
		}

		/**
		 * @brief æå®ããå¤ã§åæåããï¼
		 */
		matrix3
		(
			float m11, float m12, float m13, float m14,
			float m21, float m22, float m23, float m24,
			float m31, float m32, float m33, float m34
		)
		{
			const float* table[] =
				{
					&m11, &m12, &m13, &m14,
					&m21, &m22, &m23, &m24,
					&m31, &m32, &m33, &m34
				};
			for (size_t i = 0; i < size(); ++i) {
				elements_[i] = *table[i];
			}
		}

//}}}
//{{{ copy constructor
	matrix3(const matrix3& rhs)
	{
		for (size_t i = 0; i < size(); ++i) {
			elements_[i] = rhs.elements_[i];
		}
	}
//}}}
//{{{ operator =
	/**
	 * @note ã³ãã¼ã®ããã©ã¼ãã³ã¹ã®ããã«ãã®é¢æ°ã®å®ç¾©ã¯éè¦
	 */
	matrix3& operator = (const matrix3& rhs)
	{
		for (size_t i = 0; i < size(); ++i) {
			elements_[i] = rhs.elements_[i];
		}
		return *this;
	}
//}}}
	};

}// namespace math
}// namespace mof
