#include <mof/math/matrix2.hpp>
#include <mof/math/vector2.hpp>
#include <iostream>
#include <sstream>

int main()
{
	using namespace mof::math;
	using namespace std;
	int failed_count = 0;

	{
		float arr[] = {1, 2, 3, 4, 5, 6};
		matrix2 M(arr);
		bool failed = false;
		for (size_t i = 0; i < 6; ++i) {
			if (M[i / 3][i % 3] != i + 1) failed = true;
		}
		if (failed || M[2][0] != 0 || M[2][1] != 0 || M[2][2] != 1) {
			cerr << "Failed:" << " initialize by array test" << endl;	
			failed_count++;
		}
	}

	{	
		matrix2 M(1, 2, 3, 4, 5, 6);
		matrix2 N(1, 2, 3, 4, 5, 6);
		if (M != N) {
			cerr << "Failed:" << " M == N test" << endl;	
			failed_count++;
		}
	}
	
	{	
		matrix2 M(1, 2, 3, 4, 5, 6);
		matrix2 N(0, 2, 3, 4, 5, 6);
		if (M == N) {
			cerr << "Failed:" << " M != N test" << endl;	
			failed_count++;
		}
	}

	{
		matrix2 N1(1, 2, 3, 4, 5, 6);
		matrix2 N2(15, 13, 11, 9, 7, 5);
		matrix2 N = N1 + N2;
		matrix2 A(16, 15, 14, 13, 12, 11);
		if (N != A) {
			cerr << "Failed:" << " addition test" << endl;	
			failed_count++;
		}
	}
	
	{
		matrix2 N1(1, 2, 3, 4, 5, 6);
		matrix2 N2(15, 13, 11, 9, 7, 5);
		matrix2 N = N1 - N2;
		matrix2 A(-14, -11, -8, -5, -2, 1);
		if (N != A) {
			cerr << "Failed:" << " subtraction test" << endl;	
			failed_count++;
		}
	}

	{
		matrix2 N1(1, 2, 3, 4, 5, 6);
		matrix2 N2(2, 3, 4, 5, 6, 7);
		matrix2 N = N1 * N2;
		matrix2 A(12, 15, 21, 33, 42, 57);
		if (N != A) {
			cerr << "Failed:" << "Affine matrix N1 * N2 test" << endl;	
			failed_count++;
		}
	}
	
	{
		matrix2 M(1, 2, 3, 4, 5, 6);
		vector2 v(1, 2);
		vector2 w = M * v;
		vector2 a(8, 20);
		if (a != w) {
			cerr << "Failed:" << "M * v test" << endl;	
			failed_count++;
		}
	}


	{
		matrix2 M(1, 2, 3, 4, 5, 6);
		matrix2 N = 2 * M * 3;
		matrix2 A(6, 12, 18, 24, 30, 36);
		if (N != A) {
			cerr << "Failed:" << "s * M * s test" << endl;	
			failed_count++;
		}
	}
	
	{
		matrix2 M(3, 6, 9, 12, 15, 18);
		matrix2 N = M / 3;
		matrix2 A(1, 2, 3, 4, 5, 6);
		if (N != A) {
			cerr << "Failed:" << "M / s test" << endl;	
			failed_count++;
		}
	}


	return failed_count;
}
