require('script/moflib')
require('script/icon_manager')

ITEM_TYPE_POTION = 0
ITEM_TYPE_KNIGH  = 1
ITEM_TYPE_SWORD  = 2
ITEM_TYPE_BLADE  = 3
ITEM_TYPE_ROBE   = 4
ITEM_TYPE_ARMER  = 5


--{{{ extension_tween
ExtensionTween = {}
function ExtensionTween:new()
	local instance = {}
	setmetatable(instance, {__call = 
		function (instance, obj) 
			local prop = obj:get_properties()
			local max_width, max_height = split(prop['preferred_size'], ',')
			local min_width = 50
			local min_height = 50
			local x, y = layout(0.5, max_width, 0.5, 0.7, min_height, 0.3) 
			obj:set_tween('open.position2', 
				{
					[0] = {x + (max_width - min_width) / 2, y + (max_height - min_height) / 2},
					[15] = {x, y + (max_height - min_height) / 2},
					[20] = {x, y}
				}, 20)
			obj:set_tween('close.position2', 
				{
					[0] = {x, y},
					[15] = {x, y + (max_height - min_height) / 2},
					[20] = {x + (max_width - min_width) / 2, y + (max_height - min_height) / 2},
				}, 20)
			obj:set_tween('open.size2', 
				{
					[0] = {min_width - max_width, min_height - max_height},
					[15] = {0, min_height - max_height},
					[20] = {0, 0},
				}, 20)
			obj:set_tween('close.size2', 
				{
					[0] = {0, 0},
					[15] = {0, min_height - max_height},
					[20] = {min_width - max_width, min_height - max_height},
				}, 20)
			obj:set_tween('open.color', {[0] = {1, 1, 1, 1}, [100] = {1, 1, 1, 1}}, 20)
			obj:set_tween('close.color', {[5] = {1, 1, 1, 1}, [20] = {0, 1, 1, 1}}, 20)
		end}) -- setmetatable
	return instance
end
--}}}
--{{{ slide_tween
RightSlideTween = {}
function RightSlideTween:new(left_margin, right_margin, top_margin, bottom_margin, period)
	local instance = {}
	instance.left_margin   = left_margin
	instance.right_margin  = right_margin
	instance.top_margin    = top_margin
	instance.bottom_margin = bottom_margin
	instance.period        = period

	setmetatable(instance, {__call = 
		function (instance, obj) 
			local prop = obj:get_properties()
			local width, height = split(prop['preferred_size'], ',')
			local x, y = layout(
					instance.left_margin, width, instance.right_margin,
					instance.top_margin, height, instance.bottom_margin
				) 
			local period = instance.period
			obj:set_tween('open.position2', {[0] = {-width, y}, [period] = {x, y}}, period)
			obj:set_tween('close.position2', {[0] = {x, y}, [period] = {-width, y}}, period)
			obj:set_tween('close.color', {[period / 4] = {1, 1, 1, 1}, [period] = {0, 1, 1, 1}}, period)
		end}) -- setmetatable
	return instance
end
--}}}
--{{{ slide_tween
DownSlideTween = {}
function DownSlideTween:new(left_margin, right_margin, top_margin, bottom_margin, period)
	local instance = {}
	instance.left_margin   = left_margin
	instance.right_margin  = right_margin
	instance.top_margin    = top_margin
	instance.bottom_margin = bottom_margin
	instance.period        = period

	setmetatable(instance, {__call = 
		function (instance, obj) 
			local prop = obj:get_properties()
			local width, height = split(prop['preferred_size'], ',')
			local x, y = layout(
					instance.left_margin, width, instance.right_margin,
					instance.top_margin, height, instance.bottom_margin
				) 
			local period = instance.period
			obj:set_tween('open.position2', {[0] = {x, -height}, [period] = {x, y}}, period)
			obj:set_tween('close.position2', {[0] = {x, y}, [period] = {x, -height}}, period)
			obj:set_tween('close.color', {[period / 4] = {1, 1, 1, 1}, [period] = {0, 1, 1, 1}}, period)
		end}) -- setmetatable
	return instance
end
--}}}
--{{{ default_tween
DefaultTween = {}
function DefaultTween:new(x, y, width, height)
	local instance = {}
	instance.x      = x 
	instance.y      = y
	instance.width  = width
	instance.height = height

	setmetatable(instance, {__call = 
		function (instance, obj) 
			local prop = obj:get_properties()
			local old_width, old_height = split(prop['preferred_size'], ',')
			obj:set_tween('open.position2', {[0] = {x, y}}, 0)
			obj:set_tween('open.size2', {[0] = {instance.width - old_width, instance.height - old_height}}, 0)
			obj:set_tween('close.position2', {[0] = {-old_width * 2, 0}}, 0)
		end}) -- setmetatable
	return instance
end
--}}}
