require('script/moflib')
require('script/common')
require('script/bubble')

--{{{ question_attached
function question_attached(item_tween)
	local items = load_game_data('gamedata.item_profile')
	local list = {}
	for i = 1, #items, 1 do
		local name = get_icon_image_tag(items[i].icon_type) .. 
			'<layout w="360" h="32" xalign="left" yalign="center">' .. items[i].name .. '</layout>'
		if tonumber(items[i].attached) == 1 then 
			if tonumber(items[i].equipped) == 1 then
				table.insert(list, name .. '<layout w="100" h="32" xalign="right" yalign="center"><col name="blue">()</col></layout>')
			else
				table.insert(list, name)
			end
		end
	end
	return question('ACe(c0Xbg)', list, nil, nil, item_tween)
end
--}}}
--{{{ question_stored
function question_stored(item_tween)
	local items = load_game_data('gamedata.item_profile')
	local list = {}
	for i = 1, #items, 1 do
		local name = get_icon_image_tag(items[i].icon_type) .. 
			'<layout w="360" h="32" xalign="left" yalign="center">' .. items[i].name .. '</layout>'
		if tonumber(items[i].stored) == 1 then 
			table.insert(list, name)
		end
	end
	return question('qɃACe', list, nil, nil, item_tween)
end
--}}}
--{{{ question_relic
function question_relic(item_tween)
	local relics = load_game_data('gamedata.relic_profile')
	local list = {}
	for i = 1, #relics, 1 do
		if relics[i].num ~= 0 then
			local name = get_icon_image_tag(relics[i].icon_type) .. 
				'<layout w="360" h="32" xalign="left" yalign="center">' .. relics[i].name .. '</layout>' ..
				'<layout w="100" h="32" xalign="right" yalign="center">' .. relics[i].num .. '</layout>'
			table.insert(list, name)
		end
	end
	return question('bN', list, nil, nil, item_tween) -- relic͑Sdisable
end
--}}}
--{{{ question_setup_weapon
function question_setup_weapon(item_tween)
	local items = load_game_data('gamedata.item_profile')
	local list = {}
	local disables = {}
	local num_items = 0
	for i = 1, #items, 1 do
		local type = tonumber(items[i].type);
		local state = ''
		if items[i].equipped == '1' then
			state = '<layout w="100" h="32" xalign="right" yalign="center">()</layout></col>'
		elseif items[i].attached == '1' then
			state = '<layout w="100" h="32" xalign="right" yalign="center"><col name="blue">()</col></layout>'
		elseif items[i].stored == '1' then
			state = '<layout w="100" h="32" xalign="right" yalign="center"><col name="blue">(q)</col></layout>'
		end
		if type == ITEM_TYPE_KNIGH or type == ITEM_TYPE_SWORD or type == ITEM_TYPE_BLADE then 
			-- disable
			if items[i].equipped == '1' then
				local name = get_icon_image_tag(items[i].icon_type) .. 
					'<col name="gray"><layout w="360" h="32" xalign="left" yalign="center">' .. items[i].name .. '</layout>'
				table.insert(list, name .. state)
				table.insert(disables, num_items)
			else
				local name = get_icon_image_tag(items[i].icon_type) .. 
					'<layout w="360" h="32" xalign="left" yalign="center">' .. items[i].name .. '</layout>'
				table.insert(list, name .. state)
			end
			num_items = num_items + 1
		end
	end
	return question('镐I', list, nil, disables, item_tween)
end
--}}}
--{{{ question_setup_armer
function question_setup_armer(item_tween)
	local items = load_game_data('gamedata.item_profile')
	local list = {}
	local disables = {}
	local num_items = 0
	for i = 1, #items, 1 do
		local type = tonumber(items[i].type);
		local state = ''
		if items[i].equipped == '1' then
			state = '<layout w="100" h="32" xalign="right" yalign="center">()</layout></col>'
		elseif items[i].attached == '1' then
			state = '<layout w="100" h="32" xalign="right" yalign="center"><col name="blue">()</col></layout>'
		elseif items[i].stored == '1' then
			state = '<layout w="100" h="32" xalign="right" yalign="center"><col name="blue">(q)</col></layout>'
		end
		if type == ITEM_TYPE_ROBE or type == ITEM_TYPE_ARMER then 
			-- disable
			if items[i].equipped == '1' then
				local name = get_icon_image_tag(items[i].icon_type) .. 
					'<col name="gray"><layout w="360" h="32" xalign="left" yalign="center">' .. items[i].name .. '</layout>'
				table.insert(list, name .. state)
				table.insert(disables, num_items)
			else
				local name = get_icon_image_tag(items[i].icon_type) .. 
					'<layout w="360" h="32" xalign="left" yalign="center">' .. items[i].name .. '</layout>'
				table.insert(list, name .. state)
			end
			num_items = num_items + 1

		end
	end
	return question('hI', list, nil, disables, item_tween)
end
--}}}
--{{{ question_setup_item
function question_setup_item(item_tween)
	local items = load_game_data('gamedata.item_profile')
	local list = {}
	local disables = {}
	local num_items = 0
	for i = 1, #items, 1 do
		local state = ''
		if items[i].equipped == '1' then
			state = '<layout w="100" h="32" xalign="right" yalign="center">()</layout></col>'
		elseif items[i].attached == '1' then
			state = '<layout w="100" h="32" xalign="right" yalign="center"><col name="blue">()</col></layout>'
		elseif items[i].stored == '1' then
			state = '<layout w="100" h="32" xalign="right" yalign="center"><col name="blue">(q)</col></layout>'
		end

		-- disable
		if items[i].equipped == '1' then
			local name = get_icon_image_tag(items[i].icon_type) .. 
				'<col name="gray"><layout w="360" h="32" xalign="left" yalign="center">' .. items[i].name .. '</layout>'
			table.insert(list, name .. state)
			table.insert(disables, num_items)
		else
			local name = get_icon_image_tag(items[i].icon_type) .. 
				'<layout w="360" h="32" xalign="left" yalign="center">' .. items[i].name .. '</layout>'
			table.insert(list, name .. state)
		end
		num_items = num_items + 1
	end
	return question('ACeI(c0Xbg)', list, nil, disables, item_tween)
end
--}}}
--{{{ question_setup_ideal
function question_setup_ideal(item_tween)
	local items = load_game_data('gamedata.ideal_profile')
	local list = {}
	for i = 1, #items, 1 do
		local state = ''
		if items[i].attend == '1' then
			state = '<layout w="100" h="32" xalign="right" yalign="center"><col name="blue">(Q)</col></layout>'
		end
		local name = get_icon_image_tag(items[i].icon_type) .. 
			'<layout w="360" h="32" xalign="left" yalign="center">' .. items[i].name .. '</layout>'
		table.insert(list, name .. state)
	end
	return question('o_I(c0Xbg)', list, nil, nil, item_tween)
end
--}}}
--{{{ item_menu
function item_menu()
	local base_width = 500
	local base_height = 400

	local items = 
		{
			'<layout w="170" h="24" xalign="center">ACe</layout>',
			'<layout w="170" h="24" xalign="center">qɃACe</layout>',
			'<layout w="170" h="24" xalign="center">bN</layout>',
		}
	local tab_menu = Question:new('ACeǗj[', items, 'direction=horizontal')
	local prop = tab_menu:get_properties()
	local old_width, old_height = split(prop['preferred_size'], ',')
	local x, y = layout(0.5, base_width, 0.5, 0.5, base_height, 0.5)
	local width = base_width
	local height = 70
	-- tab_menutweenݒ
	tab_menu:set_tween('open.position2', {[0] = {x, -height}, [20] = {x, y}}, 20)
	tab_menu:set_tween('open.size2', {[0] = {width - old_width, height - old_height}}, 0)
	tab_menu:set_tween('close.position2', {[0] = {x, y}, [20] = {x, -height}}, 20)
	tab_menu:set_tween('close.size2', {[0] = {width - old_width, height - old_height}}, 0)
	tab_menu:set_tween('close.color', {[5] = {1, 1, 1, 1}, [20] = {0, 1, 1, 1}}, 20)

	local frame = tab_menu:show()
	wait_frame(frame)
	while true do
		local key = get_key()
		if key == KEY_UP then tab_menu:move_cursor_up()
		elseif key == KEY_DOWN then tab_menu:move_cursor_down()
		elseif key == KEY_LEFT then tab_menu:move_cursor_left()
		elseif key == KEY_RIGHT then tab_menu:move_cursor_right()
		elseif key == KEY_X then 
			sound("sound/cancel.wav")-- LZ
			frame = tab_menu:hide()
			wait_frame(frame)
			tab_menu:dispose()
			return 
		elseif key == KEY_Z then 
			local index = tab_menu:get_current()
			sound("sound/decide.wav")-- 艹
			-- tab_menüʒuvZ
			local prop = tab_menu:get_properties()

			-- item_menû߂tween쐬
			local item_tween = DefaultTween:new(x, y + height + 10, width, base_height - height) -- uŌ
			if index == 0 then
				question_attached(item_tween)
			elseif index == 1 then
				question_stored(item_tween)
			elseif index == 2 then
				question_relic(item_tween)
				--question('bN', {'zX15', 'X10', 'X2', 'ÕX4', '̉tX3'}, nil, nil, item_tween)
			end
		end	
	end
end
--}}}
--{{{ setup_menu
function setup_menu()
	local base_width = 500
	local base_height = 400

	local items = 
		{
			'<layout w="120" h="24" xalign="center"></layout>',
			'<layout w="120" h="24" xalign="center">h</layout>',
			'<layout w="120" h="24" xalign="center">_</layout>',
			'<layout w="120" h="24" xalign="center">ACe</layout>',
		}
	local tab_menu = Question:new('ZbgAbvj[', items, 'direction=horizontal')
	local prop = tab_menu:get_properties()
	local old_width, old_height = split(prop['preferred_size'], ',')
	local x, y = layout(0.5, base_width, 0.5, 0.5, base_height, 0.5)
	local width = base_width
	local height = 70
	-- tab_menutweenݒ
	tab_menu:set_tween('open.position2', {[0] = {x, -height}, [20] = {x, y}}, 20)
	tab_menu:set_tween('open.size2', {[0] = {width - old_width, height - old_height}}, 0)
	tab_menu:set_tween('close.position2', {[0] = {x, y}, [20] = {x, -height}}, 20)
	tab_menu:set_tween('close.size2', {[0] = {width - old_width, height - old_height}}, 0)
	tab_menu:set_tween('close.color', {[5] = {1, 1, 1, 1}, [20] = {0, 1, 1, 1}}, 20)

	local frame = tab_menu:show()
	wait_frame(frame)
	while true do
		local key = get_key()
		if key == KEY_UP then tab_menu:move_cursor_up()
		elseif key == KEY_DOWN then tab_menu:move_cursor_down()
		elseif key == KEY_LEFT then tab_menu:move_cursor_left()
		elseif key == KEY_RIGHT then tab_menu:move_cursor_right()
		elseif key == KEY_X then 
			sound("sound/cancel.wav")-- LZ
			frame = tab_menu:hide()
			wait_frame(frame)
			tab_menu:dispose()
			return 
		elseif key == KEY_Z then 
			local index = tab_menu:get_current()
			sound("sound/decide.wav")-- 艹
			-- tab_menüʒuvZ
			local prop = tab_menu:get_properties()

			-- item_menû߂tween쐬
			local item_tween = DefaultTween:new(x, y + height + 10, width, base_height - height) -- uŌ
			if index == 0 then
				question_setup_weapon(item_tween)
			elseif index == 1 then
				question_setup_armer(item_tween)
			elseif index == 2 then
				question_setup_ideal(item_tween) 
			elseif index == 3 then
				question_setup_item(item_tween)
			end
		end	
	end
end
--}}}

function main()
	--pic = Picture:new('image/yukkuri.png')
	--pic:set_tween('color', {[0] = {1, 1, 1}, [10] = {1, 0, 0}, [100] = {1, 0, 1, 1}})
	--pic:set_tween('position2', {[0] = {200, 100}, [100] = {400, 200}})
	--pic:set_tween('size2', {[0] = {100, 100}, [30] = {200, 200}, [60] = {100, 100}})
	
	local answer
	while true do
		local items = {'Xe[^X', 'ACeǗ', 'ZbgAbv', 'VXe', '<col name="gray">_WEo</col>'}
		answer = question('Cj[', items, nil, {4}, RightSlideTween:new(0.2, 0.8, 0.3, 0.7, 20))
		if answer == 0 then
			break
		elseif answer == 1 then
			--{{{ Xe[^X
			local texts = {
					'HP   200/400         QC    80%<nl/>U    200        ђʗ      20<nl/>h 100        @h   50',
					'ACe   5<nl />g_쐔       5          퓬Q_쐔      2',
					'           3JEM',
				}
			message('[X', texts, '', ExtensionTween:new())
			--}}}
		elseif answer == 2 then
			item_menu()
		elseif answer == 3 then
			setup_menu()
		elseif answer == 4 then
			--{{{ VXe
			answer = question('VXej[', {'Z[u', '[h', 'ݒ', 'ǂ'})
			--}}}
		end 
	end -- Cj[

end

