#include "Demo1.hpp"
#include "configure.hpp"
#include "mof/EventScheduler.hpp"
#include "mof/mofInput.hpp"
#include "mof/mofGraphics.hpp"
#include "mof/Application.hpp"
#include "mof/utilities.hpp"
#include "mof/widgets.hpp"
#include <mof/Texture.hpp>
#include "mof/Font.hpp"
#include "mof/Sprite.hpp"
#include "resource.hpp"
#include <mof/streams.hpp>
#include <mof/FactoryMethod.hpp>
#include <boost/bind.hpp> 
#include <memory> 
#include <mof/streams.hpp> 
#include "widget/createMenuView.hpp"
#include "widget/createFrame.hpp"
#include <mof/ConsoleIO.hpp>
#include <mof/FactoryMethod.hpp>
#include <mof/script/LuaInterpreter.hpp>
#include "script/MyEnvironment.hpp"

using namespace mof::widget;
using namespace boost;

namespace
{
	
	std::shared_ptr<mof::script::LuaInterpreter> interpreter_;
	std::shared_ptr<mof::script::Environment> environment_;
	std::shared_ptr<mof::InputReceiver> m_pInputReceiver;
	mof::EventScheduler m_scheduler;
	std::shared_ptr<mof::Sprite> m_pYukkuri;
    Frame* m_pView;
}
	
namespace Demo1
{
//{{{ initialize
    void initialize()
    {
		mof::Application::InputMode mode = mof::Application::input_mode();
		if (mode == mof::Application::INPUT_MODE_DEVICE) {
        	m_pInputReceiver = std::shared_ptr<mof::InputReceiver>(mof::InputDevice::getInputReceiver());
		}
		else if (mode == mof::Application::INPUT_MODE_LOGGING) {
        	m_pInputReceiver = std::make_shared<mof::LoggingInputReceiver>((TCHAR*)_T("inputLog.txt"));
		}
		else if (mode == mof::Application::INPUT_MODE_LOGGED) {
        	m_pInputReceiver = std::make_shared<mof::LoggedInputReceiver>((TCHAR*)_T("inputLog.txt"));
		}

		environment_ = std::make_shared<script::MyEnvironment>(m_pInputReceiver);
		interpreter_ = std::make_shared<mof::script::LuaInterpreter>(_T("script/douga.lua"));
		interpreter_->bind(environment_);
		interpreter_->start("main");
	    mof::GraphicsDevice::lightEnable(false);
	    mof::GraphicsDevice::setAlphaBlendingMode(mof::GraphicsDevice::BLENDING_MODE_ALPHA);

		m_pYukkuri = 
			std::make_shared<mof::Sprite>
			(
				std::make_shared<mof::Texture>(_T("image/yukkuri.png")), mof::Rectangle<mof::real>(0, 0, 1, 1)
			);
		{
			mof::Vector2DStream stream;
			stream << mof::Vector2D(420, 120);
			m_pYukkuri->setPositionStream(stream);
		}

		/*
		{
			using namespace mof;
			mof::Vector2D size = m_pYukkuri->getPreferredSize();
			KeyFrameAnimation<Vector2D>::KeyFrame keyframes1[] = {
				makeKeyFrame(0, mof::Vector2D(420, 120)),
				makeKeyFrame(10, mof::Vector2D(420, 100)),
				makeKeyFrame(20, mof::Vector2D(420, 70)),
				makeKeyFrame(30, mof::Vector2D(420, 60)),
				makeKeyFrame(40, mof::Vector2D(420, 70)),
				makeKeyFrame(50, mof::Vector2D(420, 120)),
				makeKeyFrame(60, mof::Vector2D(420, 130)),
				makeKeyFrame(90, mof::Vector2D(420, 130)),
				makeKeyFrame(100, mof::Vector2D(420, 120)),
				makeKeyFrame(110, mof::Vector2D(420, 70)),
				makeKeyFrame(120, mof::Vector2D(420, 60)),
				makeKeyFrame(130, mof::Vector2D(420, 70)),
				makeKeyFrame(140, mof::Vector2D(420, 100)),
				makeKeyFrame(150, mof::Vector2D(420, 120)),
			};
			KeyFrameAnimation<Vector2D>::KeyFrame keyframes2[] = {
				makeKeyFrame(0, mof::Vector2D(200, 0)),
				makeKeyFrame(60, mof::Vector2D(100, 0)),
				makeKeyFrame(90, mof::Vector2D(100, 0)),
				makeKeyFrame(150, mof::Vector2D(0, 0)),
			};
			KeyFrameAnimation<Vector2D>::KeyFrame keyframes3[] = {
				makeKeyFrame(50, mof::Vector2D(0, 0)),
				makeKeyFrame(75, mof::Vector2D(0, -60)),
				makeKeyFrame(100, mof::Vector2D(0, 0)),
				makeKeyFrame(150, mof::Vector2D(0, 0)),
				makeKeyFrame(165, mof::Vector2D(0, -60)),
				makeKeyFrame(180, mof::Vector2D(0, 0)),
			};
			KeyFrameAnimation<Vector2D>::KeyFrame keyframes4[] = {
				makeKeyFrame(50, mof::Vector2D(0, 0)),
				makeKeyFrame(75, mof::Vector2D(0, 60)),
				makeKeyFrame(100, mof::Vector2D(0, 0)),
				makeKeyFrame(150, mof::Vector2D(0, 0)),
				makeKeyFrame(165, mof::Vector2D(0, 60)),
				makeKeyFrame(180, mof::Vector2D(0, 0)),
			};

			Vector2DStream stream;
			stream << makeKeyFrameAnimationHandler<Vector2D>(keyframes1[0], lastOf(keyframes1));
			stream << makeKeyFrameAnimationHandler<Vector2D>(keyframes2[0], lastOf(keyframes2));
			stream << makeKeyFrameAnimationHandler<Vector2D>(keyframes4[0], lastOf(keyframes4));
			m_pYukkuri->setPositionStream(stream);
			
			Vector2DStream stream2;
			stream2 << makeConstantHandler(size);
			stream2 << makeKeyFrameAnimationHandler<Vector2D>(keyframes3[0], lastOf(keyframes3));
			m_pYukkuri->setSizeStream(stream2);
		}
		*/


    }
//}}}
//{{{ finalize
    void finalize( )
    {
        mof::safe_delete( m_pView );
    }
//}}} 
    

    void update()
    {
    	m_scheduler.update();
    	m_pInputReceiver->update();
		m_pYukkuri->update();
        //m_pView->update( );
		environment_->update();
		if(!environment_->isWaiting())interpreter_->update();
        
    }

    void draw()
    {
		mof::Rectangle<int> cr = mof::GraphicsDevice::getClientRegion();
	    mof::VertexXYZRHWC vertices[] = 
	    {
	    	mof::VertexXYZRHWC(mof::Vector2D(0 , 0) , mof::createColor(0 , 0 , 0)) ,
	    	mof::VertexXYZRHWC(mof::Vector2D(cr.getWidth() , 0) , mof::createColor(0 , 0 , 0)) ,
	    	mof::VertexXYZRHWC(mof::Vector2D(0 , cr.getHeight()) , mof::createColor(127 , 127 , 127)) ,
	    	mof::VertexXYZRHWC(mof::Vector2D(cr.getWidth() , cr.getHeight()) , mof::createColor(127 , 127 , 127))

	    };
	    mof::GraphicsDevice::setTexture(NULL);
	    mof::GraphicsDevice::drawVertexArray(vertices[0] , vertices[3] , mof::PRIMITIVE_TYPE_TRIANGLESTRIP );
	
		environment_->draw();
		m_pYukkuri->draw();
    }

} // namespace Demo1


