#include "Demo2.hpp"
#include "configure.hpp"
#include "mof/EventScheduler.hpp"
#include "mof/mofInput.hpp"
#include "mof/mofGraphics.hpp"
#include "mof/Application.hpp"
#include "mof/utilities.hpp"
#include "mof/widgets.hpp"
#include "resource.hpp"
#include <mof/streams.hpp>
#include <mof/FactoryMethod.hpp>
#include <boost/bind.hpp> 
#include <memory> 
#include <mof/ConsoleIO.hpp>
#include <mof/script/LuaInterpreter.hpp>
#include "script/MyEnvironment.hpp"

#include "CharacterBoard.hpp"

using namespace mof::widget;
using namespace boost;

namespace
{
	
	std::shared_ptr<mof::script::LuaInterpreter> interpreter_;
	std::shared_ptr<mof::script::Environment> environment_;
	std::shared_ptr<mof::InputReceiver> m_pInputReceiver;
	mof::Graphics3D::ptr field_;
	mof::EventScheduler m_scheduler;
	mof::Camera::ptr camera_;
	mof::Light::ptr light_;
}
	
namespace Demo2
{
//{{{ initialize
    void initialize()
    {
		mof::Application::InputMode mode = mof::Application::input_mode();
		if (mode == mof::Application::INPUT_MODE_DEVICE) {
        	m_pInputReceiver = std::shared_ptr<mof::InputReceiver>(mof::InputDevice::getInputReceiver());
		}
		else if (mode == mof::Application::INPUT_MODE_LOGGING) {
        	m_pInputReceiver = std::make_shared<mof::LoggingInputReceiver>((TCHAR*)_T("inputLog.txt"));
		}
		else if (mode == mof::Application::INPUT_MODE_LOGGED) {
        	m_pInputReceiver = std::make_shared<mof::LoggedInputReceiver>((TCHAR*)_T("inputLog.txt"));
		}

		environment_ = std::make_shared<script::MyEnvironment>(m_pInputReceiver);
		interpreter_ = std::make_shared<mof::script::LuaInterpreter>(_T("script/effect_test.lua"));
		interpreter_->start("main");
		interpreter_->bind(environment_);
	    mof::GraphicsDevice::lightEnable(false);
	    mof::GraphicsDevice::setAlphaBlendingMode(mof::GraphicsDevice::BLENDING_MODE_ALPHA);
   
		field_ = std::shared_ptr<mof::Graphics3D>(mof::MeshBuilder("model/floor.x").construct());

		// 3DV[̐ݒ
    	//mof::GraphicsDevice::lightEnable(true);
		camera_ = std::make_shared<mof::Camera>(mof::Vector3D(0, 1, -2), mof::Vector3D(0, 0, 0), mof::Vector3D(0, 1, 0));
    	//light_ = std::make_shared<mof::AmbientLight>(mof::Color4f(mof::createColor(255 , 255 , 255)));

	}
//}}}
//{{{ finalize
    void finalize( )
    {
    }
//}}} 
    

    void update()
    {
    	m_scheduler.update();
    	m_pInputReceiver->update();

		if(!environment_->isWaiting()) interpreter_->update();
		environment_->update();
		field_->update();
		camera_->update();
    }

    void draw()
    {
		mof::Rectangle<int> cr = mof::GraphicsDevice::getClientRegion();
	    mof::VertexXYZRHWC vertices[] = 
	    {
	    	mof::VertexXYZRHWC(mof::Vector2D(0 , 0) , mof::createColor(127 , 127 , 127)) ,
	    	mof::VertexXYZRHWC(mof::Vector2D(cr.getWidth() , 0) , mof::createColor(127 , 127 , 127)) ,
	    	mof::VertexXYZRHWC(mof::Vector2D(0 , cr.getHeight()) , mof::createColor(255 , 255 , 255)) ,
	    	mof::VertexXYZRHWC(mof::Vector2D(cr.getWidth() , cr.getHeight()) , mof::createColor(255 , 255 , 255))
	    };
		mof::GraphicsDevice::setViewTransform(camera_->getViewMatrix());
	    mof::GraphicsDevice::setTexture(NULL);
	    mof::GraphicsDevice::drawVertexArray(vertices[0] , vertices[3] , mof::PRIMITIVE_TYPE_TRIANGLESTRIP );
    	mof::GraphicsDevice::clearZBuffer();
		field_->draw();
		environment_->draw();
    }

} // namespace Demo2


