#include "TestScene.hpp"
#include "mof/GraphicsDevice.hpp"
#include <vector>
#include "mof/VertexBuffer.hpp"
#include "mof/AmbientLight.hpp"
#include "mof/MaterialBuilder.hpp"
#include "mof/Material.hpp"
#include "mof/Camera.hpp"
#include "mof/Texture.hpp"
#include "mof/MeshBuilder.hpp"
#include "mof/Graphics3D.hpp"
#include "mof/EventScheduler.hpp"
#include "mof/EventCondition.hpp"
#include "mof/Board.hpp"
#include "mof/Font.hpp"
#include "mof/streams.hpp"
#include "CharacterBoard.hpp"
#include <vector>
#include <boost/bind.hpp>
#include <math.h>
#include "mof/Finalizer.hpp"
#include "mof/utilities.hpp"

namespace 
{

    mof::AmbientLight* m_pLight;
    mof::Camera* m_pCamera;
    std::shared_ptr<mof::Texture> m_pTexture;
    std::vector<::CharacterBoard*> m_modelList;
    mof::Graphics3D* m_pBox;
    mof::EventScheduler* m_pScheduler;
    mof::Manipulator<mof::Color4f>::Handler m_backgroundColor;
    mof::FrameNumber m_backgroundColorFrame;
    mof::tstring m_part;
};



    
namespace TestScene
{

    void begin(){
        std::vector<mof::Manipulator<mof::Matrix3D>::Handler> handlerList;
    
        {
        std::pair<mof::FrameNumber , mof::Vector3D> keyFrames[4];
        keyFrames[0] = std::pair<mof::FrameNumber , mof::Vector3D>( 25 , mof::Vector3D( mof::deg2rad(-90) , 0 , 0));
        keyFrames[1] = std::pair<mof::FrameNumber , mof::Vector3D>( 50 , mof::Vector3D( mof::deg2rad(-80) , 0 , 0));
        keyFrames[2] = std::pair<mof::FrameNumber , mof::Vector3D>( 75 , mof::Vector3D( mof::deg2rad(-25) , 0 , 0));
        keyFrames[3] = std::pair<mof::FrameNumber , mof::Vector3D>( 100 , mof::Vector3D( mof::deg2rad(0) , 0 , 0));
        mof::Manipulator<mof::Matrix3D>::Handler handler(new mof::Rotation3D(keyFrames[0] , mof::lastOf(keyFrames)));
        handlerList.push_back(handler);
        }
        {
        mof::Manipulator<mof::Matrix3D>::Handler handler(
            mof::makeConstantHandler(mof::Matrix3D::createTranslation(mof::Vector3D(0 , 0 , -4.5f)))
            );
        handlerList.push_back(handler);
        }
        {
        std::pair<mof::FrameNumber , mof::Vector3D> keyFrames[3];
        keyFrames[0] = std::pair<mof::FrameNumber , mof::Vector3D>( 0 , mof::Vector3D( 0 , mof::deg2rad(70) , 0));
        keyFrames[1] = std::pair<mof::FrameNumber , mof::Vector3D>( 130 , mof::Vector3D( 0 , mof::deg2rad(360) , 0));
        mof::Manipulator<mof::Matrix3D>::Handler handler(new mof::Rotation3D(keyFrames[0] , mof::lastOf(keyFrames)));
        handler = mof::Manipulator<mof::Matrix3D>::Handler(new mof::Loop<mof::Matrix3D>(handler , 200));
        handlerList.push_back(handler);
        }
    
        int size = handlerList.size();
        handlerList.resize(size + 1);

        mof::tstring title[] = { _T("R") , _T("N") , _T("O") , _T("") , _T("") , _T("") , _T("") ,
            _T("") , _T("q") , _T("o") , _T("f") , _T("J") , _T("") , _T("") , _T("") , _T("J") ,
            _T("") , _T("") , _T("") , _T("") };

        for(int i = 0 ; i < 20 ; i++)
        {
            m_modelList.push_back(new ::CharacterBoard( title[i]));
            {
            mof::Manipulator<mof::Matrix3D>::Handler handler(
            	mof::makeConstantHandler(mof::Matrix3D::createRotation(mof::Vector3D(0 , mof::deg2rad(-360.0f/20 * i) , 0)))
            	);
            handlerList.at(size) = handler;
            }
            mof::Manipulator<mof::Matrix3D>::Handler handler(mof::makeCascadeHandler<mof::Matrix3D >(handlerList.front() , handlerList.back()));
            m_modelList.at(i)->setWorldMatrix(handler);
        }

    
        {
        mof::MeshBuilder meshBuilder( "model/demo/box.x");
        m_pBox = meshBuilder.construct();
        handlerList.clear();
    
        {
        std::pair<mof::FrameNumber , mof::Vector3D> keyFrames[2];
        keyFrames[0] = std::pair<mof::FrameNumber , mof::Vector3D>( 0 , mof::Vector3D( 0 , 0 , 0));
        keyFrames[1] = std::pair<mof::FrameNumber , mof::Vector3D>( 130 , mof::Vector3D( mof::deg2rad(360) , mof::deg2rad(360) , mof::deg2rad(360)));
        mof::Manipulator<mof::Matrix3D>::Handler handler(new mof::Rotation3D(keyFrames[0] , keyFrames[1]));
        handler = mof::Manipulator<mof::Matrix3D>::Handler(new mof::Loop<mof::Matrix3D>(handler , 130));
        handlerList.push_back(handler);
        }
        mof::Manipulator<mof::Matrix3D>::Handler handler(mof::makeCascadeHandler<mof::Matrix3D >(handlerList.front() , handlerList.back()));
        m_pBox->setWorldMatrix(handler);
        }

        {
            std::pair<mof::FrameNumber , mof::Vector3D> keyFrames[2];
            keyFrames[0] = std::pair<mof::FrameNumber , mof::Vector3D>( 0 , mof::Vector3D(0 , 10.5f , -5));
            keyFrames[1] = std::pair<mof::FrameNumber , mof::Vector3D>( 130 , mof::Vector3D(0 , 1.5f , -10 ));
            mof::Manipulator<mof::Vector3D>::Handler handler(mof::makeKeyFrameAnimationHandler<mof::Vector3D>(keyFrames[0] , keyFrames[1]));
            m_pCamera->setEye(handler);
        }
    
    }
    
    void showTitle(){
        std::vector<mof::Manipulator<mof::Matrix3D>::Handler> handlerList;
        mof::Manipulator<mof::Matrix3D>::Handler handler;
        for(unsigned int i = 0 ; i < m_modelList.size() ; ++i){
            handlerList.clear();
            mof::Matrix3D matrix = m_modelList.at(i)->getWorldMatrix();

            {
            	mof::Vector3D a = mof::Vector3D(1 , 0 , 0) * matrix;
            	float rad = static_cast<float>(atan2( -a.x , -a.z));
            	std::pair<mof::FrameNumber , mof::Vector3D> keyFrames[] = {
            		std::pair<mof::FrameNumber , mof::Vector3D>( 20 , mof::Vector3D(0 , 0 , 0) ) ,
            		std::pair<mof::FrameNumber , mof::Vector3D>( 50 , mof::Vector3D(0 , -rad  , 0))
            	};
            	handler = mof::Manipulator<mof::Matrix3D>::Handler(new mof::Rotation3D(keyFrames[0] , keyFrames[1]));
            	handlerList.push_back(handler);
            }
            	
            {
            	handler = mof::makeConstantHandler(matrix);
            	handlerList.push_back(handler);
            }
            	
            	
            {
            	float y = (i > 7) ? -1.0f : 0;
            	float x = (i > 7) ? i - 8.0f : i;
            	mof::Vector3D position(1.0f * x - 20 , y , -5);
            	std::pair<mof::FrameNumber , mof::Vector3D> keyFrames[] = {
            		std::pair<mof::FrameNumber , mof::Vector3D>( 0 , mof::Vector3D(0 , 0 , 0) ) ,
            		std::pair<mof::FrameNumber , mof::Vector3D>( 50 , position - m_modelList.at(i)->getPosition())
            	};
            	handler = mof::Manipulator<mof::Matrix3D>::Handler(new mof::Translation3D(keyFrames[0] , keyFrames[1]));
            	handlerList.push_back(handler);
            }
            handler = mof::Manipulator<mof::Matrix3D>::Handler(
            	mof::makeCascadeHandler<mof::Matrix3D , mof::Multiply<mof::Matrix3D>>(handlerList.front() , handlerList.back())
            	);
            m_modelList.at(i)->setWorldMatrix(handler);
            m_modelList.at(i)->setFinishColor(70 , 20);
            m_modelList.at(i)->setFrameNumber(0);
        }
    
        

        {
            mof::Vector3D eye = m_pCamera->getEye();
            std::pair<mof::FrameNumber , mof::Vector3D> keyFrames[] = {
            	std::pair<mof::FrameNumber , mof::Vector3D>( 0 , eye) ,
            	std::pair<mof::FrameNumber , mof::Vector3D>( 20 , eye) ,
            	std::pair<mof::FrameNumber , mof::Vector3D>( 60 , mof::Vector3D(-16 , 1.0f , eye.z + 1)) ,
            	std::pair<mof::FrameNumber , mof::Vector3D>( 70 , mof::Vector3D(-14 , -0.5f , eye.z - 8 ))
            };
            mof::Manipulator<mof::Vector3D>::Handler handler(mof::makeKeyFrameAnimationHandler<mof::Vector3D>(keyFrames[0] , keyFrames[3]));
            m_pCamera->setEye(handler);
        }
            
        {
            std::pair<mof::FrameNumber , mof::Vector3D> keyFrames[] = {
            	std::pair<mof::FrameNumber , mof::Vector3D>( 0 , mof::Vector3D(0 , 0 , 0)) ,
            	std::pair<mof::FrameNumber , mof::Vector3D>( 20 , mof::Vector3D(0 , 0 , 0)) ,
            	std::pair<mof::FrameNumber , mof::Vector3D>( 60 , mof::Vector3D(-14 , 0.0f , 0 ))
            };
            mof::Manipulator<mof::Vector3D>::Handler handler(mof::makeKeyFrameAnimationHandler<mof::Vector3D>(keyFrames[0] , keyFrames[2]));
            m_pCamera->setCenter(handler);
        }
        m_pCamera->setFrameNumber(0);

        {
            std::pair<mof::FrameNumber , mof::Color4f> keyFrames[] = {
            	std::pair<mof::FrameNumber , mof::Color4f>( 70 , mof::Color4f(mof::createColor(0 , 20 , 55)) ) ,
            	std::pair<mof::FrameNumber , mof::Color4f>( 90 , mof::Color4f(mof::createColor(255 , 255 , 255)) )
            };
            m_backgroundColor = mof::Manipulator<mof::Color4f>::Handler(mof::makeKeyFrameAnimationHandler<mof::Color4f>(keyFrames[0] , keyFrames[1]));
            m_backgroundColorFrame = 0;
        }
    }

    void addPart(){
        std::vector<mof::Manipulator<mof::Matrix3D>::Handler> handlerList;
        mof::Manipulator<mof::Matrix3D>::Handler handler;
        {
            
            handlerList.clear();
            std::pair<mof::FrameNumber , mof::Vector3D> keyFrames[] = {
            	std::pair<mof::FrameNumber , mof::Vector3D>( 0 , mof::Vector3D(0 , mof::deg2rad(270) , 0) ) ,
            	std::pair<mof::FrameNumber , mof::Vector3D>( 40 , mof::Vector3D(0 , mof::deg2rad(360) , 0))
            	};
            handler = mof::Manipulator<mof::Matrix3D>::Handler(new mof::Rotation3D(keyFrames[0] , keyFrames[1]));
            handlerList.push_back(handler);

            handler = mof::makeConstantHandler(mof::Matrix3D::createScaling(mof::Vector3D(4 , 1 , 1)));
            handlerList.push_back(handler);
            handler = mof::makeConstantHandler(mof::Matrix3D::createTranslation(mof::Vector3D(-10 , -2 , -5)));
            handlerList.push_back(handler);
            handler = mof::Manipulator<mof::Matrix3D>::Handler(
            	mof::makeCascadeHandler<mof::Matrix3D , mof::Multiply<mof::Matrix3D>>(handlerList.front() , handlerList.back()));
            ::CharacterBoard* pPartBoard = new ::CharacterBoard( m_part);
            pPartBoard->setWorldMatrix(handler);
            pPartBoard->setPartColor(0 , 1);
            m_modelList.push_back(pPartBoard);
        }
    }






void initialize( )
{
    m_pLight = NULL;
    m_pCamera = NULL;
    m_pBox = NULL;
    m_pScheduler = NULL;
    m_backgroundColorFrame = 0;
    m_part = _T("part9");
    
    

    mof::GraphicsDevice::lightEnable(true);
    m_pLight = new mof::AmbientLight(  mof::Color4f(mof::createColor(255 , 255 , 255)));

    m_pCamera = new mof::Camera(mof::Vector3D(0 , 0.5f , -10) , mof::Vector3D(0 , 0 , 0) , mof::Vector3D(0 , 1 , 0));
    m_backgroundColor = 
        mof::Manipulator<mof::Color4f>::Handler(mof::makeConstantHandler(mof::Color4f(mof::createColor(0 , 20 , 55))));

    m_pScheduler = new mof::EventScheduler();
    m_pScheduler->addEvent( 125 ,  &::TestScene::showTitle );
    m_pScheduler->addEvent( 125+70 ,  &::TestScene::addPart );
    begin();

    
}


void finalize(){
        for(std::vector<::CharacterBoard*>::iterator itr = m_modelList.begin() ;
            itr != m_modelList.end() ;
            ++itr ){
            delete *itr;
        }
        delete m_pCamera;
        delete m_pBox;
        delete m_pScheduler;
        delete m_pLight;
    }




void update(){
    for(std::vector<::CharacterBoard*>::iterator itr = m_modelList.begin() ;
        itr != m_modelList.end() ;
        ++itr ){
        (*itr)->update();
    }
    m_pBox->update();
    m_pScheduler->update();
    m_pCamera->update();
    m_backgroundColorFrame++;
}



void draw()
{
    //m_pGraphics->setZBuffer(false);
    mof::GraphicsDevice::setViewTransform(m_pCamera->getViewMatrix());
    mof::GraphicsDevice::clearRenderTarget(m_backgroundColor->value(m_backgroundColorFrame).toColorCode());
    mof::GraphicsDevice::clearZBuffer();
    mof::GraphicsDevice::setAlphaBlendingMode(mof::GraphicsDevice::BLENDING_MODE_ALPHA);
    
    //m_pBox->draw();
    mof::GraphicsDevice::lightEnable(false);
    std::list<mof::Board*> boardList;

    for(std::vector<::CharacterBoard*>::iterator itr = m_modelList.begin() ;
        itr != m_modelList.end() ;
        ++itr ){
            (*itr)->append(boardList);
    }

    for(std::list<mof::Board*>::iterator itr = boardList.begin() ;
        itr != boardList.end() ;
        ++itr ){
            (*itr)->draw();
    }

}

} // namespace TestScene
