#include "configure.hpp"
#include "mof/Application.hpp"
#include "mof/streams.hpp"
#include "mof/Color.hpp"
#include <exception>
#include "mof/utilities.hpp"
#include "mof/ConsoleIO.hpp"
#include <conio.h>
#include "mof/Font.hpp"

#include "TestScene.hpp"
#include "Demo1.hpp"
#include "Demo2.hpp"
#include "Demo3.hpp"
#include "Settings.hpp"


int main(int , char**)
{
    mof::Font::addFontResource( FONT_PATH_UME );
	::Settings settings;
	int result = ::LoadSettings(&settings);
	try
	{
		if (!result) throw std::runtime_error("bad settings");
	    { // AvP[V̏
			int upf = settings.fps == 30 ? 2 : 1;
			int interval = settings.fps == 30 ? 32 : 16;
		    mof::Application::initialize
		    (
		        _T("MyApplication") ,
		        settings.screen.width, settings.screen.height,
				settings.screen_mode, interval, upf,
				(mof::Application::InputMode)settings.input_mode, 
				settings.enable_output_frame? true: false,
				settings.enable_output_audio? true: false
		    ); 
		}
		
		{ // V[̃ZbgƊJn
		    mof::Scene scene;
		    #define FIRST_SCENE Demo2
		    scene.initialize = FIRST_SCENE::initialize;
		    scene.finalize = FIRST_SCENE::finalize;
		    scene.update = FIRST_SCENE::update;
		    scene.draw = FIRST_SCENE::draw;
		    mof::Application::run( scene );
		}
	}
	catch(std::exception& e)
	{
		MessageBox(NULL, e.what(), "O܂", MB_OK);
	}
	mof::Application::finalize();

	return 0;
}
