#include "AttackAction.h"
#include "BattlerFacade.h"



et::AttackAction::AttackAction(et::BattlerFacade* pBattler , et::BattlerFacade* pTarget , int cost ,  float correction)
: Action(pBattler , pTarget , cost)
{
	m_correction = correction;
}

et::AttackAction::~AttackAction(void)
{
}


int et::AttackAction::doActionTo(et::BattlerFacade* pTarget){
	float totalPower = (float)m_pBattler->getParameter().attack * m_correction;
	int damage = (int)totalPower - pTarget->getParameter().diffence;
	if(m_pBattler->getParameter().critical)damage = (int)totalPower;
	if(pTarget->getParameter().guard)damage *= 0.5;//K[hȂǃ_[W
	if(damage < 0)damage = 0;
	int effect = -damage;

	et::BattlerParameter parameter = pTarget->getParameter();
	if(parameter.hp <= damage){
		parameter.hp = 0;
		parameter.alive = false;
	}
	else parameter.hp -= damage;
	parameter.dActionPoint += 1;
	pTarget->setParameter(parameter);
	return effect;
}

mof::AnimationResource et::AttackAction::createApproachAnimation(){
	mof::Vector3D targetPosition = getTargetList().front()->getPosition();
	targetPosition.x += (m_pBattler->getType() == et::ENEMY)? -0.2f : 0.2f;
	return m_pBattler->setMovingAnimation(targetPosition , 15);
}


mof::AnimationResource et::AttackAction::createExecuteAnimation(){
	return m_pBattler->setCastAnimation(0);
}

mof::tstring et::AttackAction::getActionMessage(){
	return mof::tstring(_T(""));
}