#include "CommandMenu.h"
#include "mof/KeyFrameAnimation.h"
#include "MyWindow.h"
#include "FightingMenu.h"
#include "BattlerGroup.h"
#include "BattlerFacade.h"
#include "BattleData.h"

et::CommandMenu::CommandMenu( mof::TextureManager* pTextureManager , et::BattleData* pBattleData )
: et::MyFrame(mof::Line2D( 0 , 0 , 200 , 300) , true , pTextureManager->getResource(_T("image/frame0.png")) )
{
	m_pBattleData = pBattleData;
	m_pSelector = NULL;
	m_pTextureManager = pTextureManager;
	std::vector<mof::Window*> selectables;

	mof::Window* pSelectable = NULL;
	addSelectableTextItem(this , selectables , _T("") , 16);
	addSelectableTextItem(this , selectables , _T("") , 16);
	pSelectable = addSelectableTextItem(this , selectables , _T("ɂ") , 16);
	pSelectable->setAvailable(false);
	pSelectable = addSelectableTextItem(this , selectables , _T("I[g") , 16);
	pSelectable->setAvailable(false);
	m_pSelector = new mof::SelectionModel(selectables , mof::AnimationResource());
	setVisible(true);
}

et::CommandMenu::~CommandMenu(void)
{
	delete m_pSelector;
}





void et::CommandMenu::setVisible(bool visible){
	et::MyFrame::setVisible(visible);
	if(visible){
		mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation();
		pAnimation->setPosition(0 , mof::Vector2D(-200 ,370));
		pAnimation->setPosition(15 , mof::Vector2D(10 , 370));
		mof::AnimationResource resource(pAnimation);
		m_pSelector->setMenuAnimation(resource);
		setAnimation(0 , resource);
	}
	else {
		mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation();
		pAnimation->setPosition(0 , mof::Vector2D(10 , 370));
		pAnimation->setPosition(15 , mof::Vector2D(-200 , 370));
		mof::AnimationResource resource(pAnimation);
		m_pSelector->setMenuAnimation(resource);
		setAnimation(0 , resource);
	}
}

et::MyFrame* et::CommandMenu::performAction(){
	
	switch(getSelectionModel()->getSelectingIndex()){
		case 0 : //
			setVisible(false);
			return new FightingMenu(m_pTextureManager , m_pBattleData);
		case 1 : //
			{
				et::BattleAction action;
				action.type = et::BattleAction::WAIT;
				m_pBattleData->setBattleAction(action);
				return this;
			}
		case 2 : //ɂ
			return this;
		case 3 : //I[g
			return this;
		default :
			DEBUG_PRINT("`̃ANVv܂");
			return NULL;
	}
}



mof::Window* et::CommandMenu::addSelectableTextItem(mof::Window* pOwner, std::vector<mof::Window*>& selectables , TCHAR* text , int size){
	mof::Window* pSelectable = new et::MyWindow(mof::Sprite::createSpriteFromText(text , size) , m_pTextureManager);
	pOwner->add(pSelectable);
	selectables.push_back(pSelectable);
	return pSelectable;
}