#pragma once
#include "mof/PixelMap.h"
#include "MapBuilder.h"


namespace et{
	typedef VertexTypeMap VertexTypeDungeon;
	typedef MapBuffer DungeonBuffer;
	class DungeonBuilder : public MapBuilder
	{
		mof::PixelMap m_map;
		int m_blockWidth , m_blockHeight;
	protected :
		mof::PixelMap& getMap(){return m_map;}
	public:
		DungeonBuilder(mof::PixelMap& map , mof::TextureManager* pTextureManager , float scale);
		virtual ~DungeonBuilder(void);
		void setBlockSize(int width , int height);
		DungeonBuffer* createBlock(int x , int y);
		mof::Color getMapImageColor(int x , int y){return m_map.get(x , y);}
	};


};