#include "DungeonBuilderA.h"
#include "MapImageColor.h"

et::DungeonBuilderA::DungeonBuilderA(mof::PixelMap& map , mof::TextureManager* pTextureManager , float scale)
: et::DungeonBuilder(map , pTextureManager , scale)
{
}

et::DungeonBuilderA::~DungeonBuilderA(void)
{
}

void et::DungeonBuilderA::addParts(std::vector<et::VertexTypeDungeon>& vertices , int x , int y){
	mof::PixelMap map = getMap();
	const float SCALE = getScale();
	et::VertexTypeDungeon vertex;
	vertex.y = 0.0f;
	float t = 0.0001f;//eNX`E␳
	vertex.color = mof::createColor(255 , 255 , 255);
	float tableX[]={ 0.0f , SCALE , SCALE , SCALE , 0.0f , 0.0f};
	float tableZ[]={ 0.0f , 0.0f , -SCALE , -SCALE , -SCALE , 0.0f};
	float tableTU[]={ 0.25f+t , 0.5f-t , 0.5f-t , 0.5f-t , 0.25f+t , 0.25f+t};
	float tableTV[]={ 0.0f+t, 0.0f+t , 0.25f-t , 0.25f-t , 0.25f-t , 0.0f+t};


	if(et::isWalkableColor(map.get(x , y))){
		for(int i = 0 ; i < 6 ; i++){
			vertex.x = tableX[i] + SCALE * x;
			vertex.z = tableZ[i] - SCALE * y;
			vertex.tu = tableTU[i];
			vertex.tv = tableTV[i];
			vertices.push_back(vertex);
		}
		return;
	}
	else if(map.get(x , y) == mof::createColor( 255 , 0 , 0)){
		
		for(int i = 0 ; i < 6 ; i++){
			vertex.x = tableX[i] + SCALE * x;
			vertex.y = SCALE;
			vertex.z = tableZ[i] - 0.3f * y;
			vertex.tu = tableTU[i] -0.25f;
			vertex.tv = tableTV[i];
			vertices.push_back(vertex);
		}

		//ǂǉ
		if(y > 0 && map.get(x , y-1) != mof::createColor(255 , 0 , 0)){
			//ɕ
			for(int i = 0 ; i < 6 ; i++){
				vertex.x = tableX[i] + SCALE * x;
				vertex.y = tableZ[i] +SCALE;
				vertex.z =  - SCALE * y;
				vertex.tu = tableTU[i] - 0.25f;
				vertex.tv = tableTV[i];
				vertices.push_back(vertex);
			}
		}
		if(y < map.getHeight() && map.get(x , y+1) != mof::createColor(255 , 0 , 0)){
			//ɕ
			for(int i = 0 ; i < 6 ; i++){
				vertex.x = tableX[i] + SCALE * x;
				vertex.y = tableZ[i] + SCALE;
				vertex.z =  - SCALE * (y+1);
				if(et::isWalkableColor(map.get(x , y+1)))vertex.tu = tableTU[i] + 0.5f;
				else vertex.tu = tableTU[i] - 0.25f;
				vertex.tv = tableTV[i];
				vertices.push_back(vertex);
			}
		}
		if(x > 0 && map.get(x-1 , y) != mof::createColor(255 , 0 , 0)){
			//ɕ
			for(int i = 0 ; i < 6 ; i++){
				vertex.x = SCALE * x;
				vertex.y = tableZ[5-i] + SCALE;
				vertex.z =   -SCALE * (y+1) + tableX[5-i];
				if(et::isWalkableColor(map.get(x-1 , y)))vertex.tu = tableTU[5-i] + 0.5f;
				else vertex.tu = tableTU[5-i] - 0.25f;
				vertex.tv = tableTV[5-i];
				vertices.push_back(vertex);
			}
		}
		if(x < map.getWidth() && map.get(x+1 , y) != mof::createColor(255 , 0 , 0)){
			//Eɕ
			for(int i = 0 ; i < 6 ; i++){
				vertex.x = SCALE * (x+1);
				vertex.y = tableZ[i] + SCALE;
				vertex.z =   -SCALE * (y+1) + tableX[i];
				if(et::isWalkableColor(map.get(x+1 , y)))vertex.tu = tableTU[i] + 0.5f;
				else vertex.tu = tableTU[i] - 0.25f;
				vertex.tv = tableTV[i];
				vertices.push_back(vertex);
			}
		}	
	}
	else return;

	
}