#include "FightingMenu.h"
#include "mof/KeyFrameAnimation.h"
#include "MyWindow.h"
#include "TargetMenu.h"
#include "IdealMenu.h"
#include "UsingBattleItemMenu.h"
#include "ItemMenu.h"
#include "BattlerGroup.h"
#include "BattlerFacade.h"

et::FightingMenu::FightingMenu( mof::TextureManager* pTextureManager  , et::BattleData* pBattleData )
: et::MyFrame(mof::Line2D( 0 , 0 , 200 , 300) , true , pTextureManager->getResource(_T("image/frame0.png")) )
{
	m_pBattleData = pBattleData;

	m_pSelector = NULL;
	m_pTextureManager = pTextureManager;
	std::vector<mof::Window*> selectables;

	mof::Window* pSelectable = NULL;
	et::BattlerFacade* pHero = m_pBattleData->getBattlerGroup()->getHeroBattler();
	pSelectable = addSelectableTextItem(this , selectables , _T("(AP-3)") , 16);
	if(pHero->getParameter().actionPoint < 3)pSelectable->setAvailable(false);
	pSelectable = addSelectableTextItem(this , selectables , _T("_(AP-5)") , 16);
	if(pHero->getParameter().actionPoint < 5)pSelectable->setAvailable(false);
	pSelectable = addSelectableTextItem(this , selectables , _T("ACe(AP-2)") , 16);
	if(pHero->getParameter().actionPoint < 2)pSelectable->setAvailable(false);
	pSelectable = addSelectableTextItem(this , selectables , _T("ڂ(AP-1)") , 16);
	if(pHero->getParameter().actionPoint < 1)pSelectable->setAvailable(false);
	m_pSelector = new mof::SelectionModel(selectables , mof::AnimationResource());
	setVisible(true);
}

et::FightingMenu::~FightingMenu(void)
{
	delete m_pSelector;
}





void et::FightingMenu::setVisible(bool visible){
	et::MyFrame::setVisible(visible);
	if(visible){
		mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation();
		pAnimation->setPosition(0 , mof::Vector2D(-200 ,370));
		pAnimation->setPosition(15 , mof::Vector2D(10 , 370));
		mof::AnimationResource resource(pAnimation);
		m_pSelector->setMenuAnimation(resource);
		setAnimation(0 , resource);
	}
	else {
		mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation();
		pAnimation->setPosition(0 , mof::Vector2D(10 , 370));
		pAnimation->setPosition(15 , mof::Vector2D(-200 , 370));
		mof::AnimationResource resource(pAnimation);
		m_pSelector->setMenuAnimation(resource);
		setAnimation(0 , resource);
	}
}

et::MyFrame* et::FightingMenu::performAction(){
	
	switch(getSelectionModel()->getSelectingIndex()){
		case 0 : //
			{
				et::BattleAction action;
				action.type = et::BattleAction::ATTACK_WEAPON;
				return new TargetMenu(m_pTextureManager , m_pBattleData , action , 160);
			}
		case 1 : //ꂢ
			return new IdealMenu(m_pTextureManager , m_pBattleData);
		case 2 : //ACe
			{
				et::ItemOperatorFactory* pOperationMenuFactory = new UsingBattleItemMenuFactory(m_pTextureManager , m_pBattleData);
				return new et::ItemMenu( m_pTextureManager ,  m_pBattleData->getItemList() , pOperationMenuFactory);
			}
		case 3 : //ڂ
			{
				et::BattleAction action;
				action.type = et::BattleAction::GUARD;
				//K[hԂ
				et::BattlerParameter parameter = m_pBattleData->getBattlerGroup()->getHeroBattler()->getParameter();
				parameter.guard = true;
				parameter.dActionPoint -= 1;
				m_pBattleData->getBattlerGroup()->getHeroBattler()->setParameter(parameter);
				m_pBattleData->setBattleAction(action);
				return this;
			}
		default :
			DEBUG_PRINT("`̃ANVv܂");
			return NULL;
	}
}



mof::Window* et::FightingMenu::addSelectableTextItem(mof::Window* pOwner, std::vector<mof::Window*>& selectables , TCHAR* text , int size){
	mof::Window* pSelectable = new et::MyWindow(mof::Sprite::createSpriteFromText(text , size) , m_pTextureManager);
	pOwner->add(pSelectable);
	selectables.push_back(pSelectable);
	return pSelectable;
}