#include "IdealMenu.h"
#include "mof/KeyFrameAnimation.h"
#include "MyWindow.h"
#include "TargetMenu.h"
#include "BattlerGroup.h"
#include "BattlerFacade.h"


mof::Window* et::IdealMenu::addSelectableTextItem(mof::Window* pOwner, std::vector<mof::Window*>& selectables , TCHAR* text , int size){
	mof::Window* pSelectable = new et::MyWindow(mof::Sprite::createSpriteFromText(text , size) , m_pTextureManager);
	pOwner->add(pSelectable);
	selectables.push_back(pSelectable);
	return pSelectable;
}

et::IdealMenu::IdealMenu( mof::TextureManager* pTextureManager  , et::BattleData* pBattleData )
: et::MyFrame(mof::Line2D( 0 , 0 , 200 , 300) , true , pTextureManager->getResource(_T("image/frame0.png")) )
{
	m_pBattleData = pBattleData;

	m_pSelector = NULL;
	m_pTextureManager = pTextureManager;
	std::vector<mof::Window*> selectables;

	mof::Window* pSelectable = NULL;
	//_̃Xg쐬
	for(std::vector<et::BattlerFacade*>::const_iterator itr = m_pBattleData->getBattlerGroup()->getBattlerList().begin() ;
		itr != m_pBattleData->getBattlerGroup()->getBattlerList().end() ; ++itr){
		if((*itr)->getType() != et::IDEAL || !(*itr)->getParameter().alive)continue;
		pSelectable = addSelectableTextItem(this , selectables , (TCHAR*)(*itr)->getParameter().name.c_str() , 16);
		if((*itr)->getParameter().actionPoint < 5)pSelectable->setAvailable(false);
		
	}
	m_pSelector = new mof::SelectionModel(selectables , mof::AnimationResource());
	setVisible(true);
}

et::IdealMenu::~IdealMenu(void)
{
	delete m_pSelector;
}





void et::IdealMenu::setVisible(bool visible){
	et::MyFrame::setVisible(visible);
	if(visible){
		mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation();
		pAnimation->setPosition(0 , mof::Vector2D(160 ,500));
		pAnimation->setPosition(10 , mof::Vector2D(160 , 370));
		mof::AnimationResource resource(pAnimation);
		m_pSelector->setMenuAnimation(resource);
		setAnimation(0 , resource);
	}
	else {
		mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation();
		pAnimation->setPosition(0 , mof::Vector2D(160 , 370));
		pAnimation->setPosition(10 , mof::Vector2D(160 , 500));
		mof::AnimationResource resource(pAnimation);
		m_pSelector->setMenuAnimation(resource);
		setAnimation(0 , resource);
	}
}

et::MyFrame* et::IdealMenu::performAction(){
	int index = getSelectionModel()->getSelectingIndex();
	et::BattleAction action;
	action.type = et::BattleAction::CAST;
	int cntIdeal = 0;
	for(std::vector<et::BattlerFacade*>::const_iterator itr = m_pBattleData->getBattlerGroup()->getBattlerList().begin() ;
		itr != m_pBattleData->getBattlerGroup()->getBattlerList().end() ; ++itr){
		if((*itr)->getType() != et::IDEAL || !(*itr)->getParameter().alive)continue;
		else if(index == cntIdeal++)action.idealIndex = index;
	}
	
	if(action.idealIndex == 0)return new et::TargetMenu(m_pTextureManager , m_pBattleData , action , 300);//P
	else if(action.idealIndex == 1){
		action.pTarget = NULL;
		m_pBattleData->setBattleAction(action);
		return this;
	}
	else if(action.idealIndex == 2){
		action.pTarget = m_pBattleData->getBattlerGroup()->getHeroBattler();
		m_pBattleData->setBattleAction(action);
		return this;
	}
}


