#include "MapBuilder.h"
#include "mof/SoftVertexBufferImpl.h"
#include "mof/HardVertexBufferImpl.h"



et::MapBuilder::MapBuilder( mof::TextureManager* pTextureManager , float scale , int width , int height)
: m_scale(scale) , m_pTextureManager(pTextureManager) , m_width(width) , m_height(height)
{
	
}

et::MapBuilder::~MapBuilder(void)
{
}



et::MapBuffer* et::MapBuilder::create(){


	std::vector<et::VertexTypeMap> vertices;
	
	for(int x = 0 ; x < m_width ; x++){
		for(int y = 0 ; y < m_height ; y++){
			addParts(vertices , x , y);
		}
	}

	return new mof::SoftVertexBuffer<et::VertexTypeMap>(et::MapBuffer::PRIMITIVE_TYPE_TRIANGLELIST , vertices);
}


float et::MapBuilder::getScale(){
	return m_scale;
}