#pragma once
#include <vector>
#include "mof/Graphics.h"


namespace et{
	typedef mof::VertexXYZCUV VertexTypeMap;
	typedef mof::VertexBuffer<VertexTypeMap> MapBuffer;
	class MapBuilder
	{
		
		float m_scale;
		int m_width;
		int m_height;
		
	protected :
		mof::TextureManager* m_pTextureManager;
		virtual void addParts(std::vector<VertexTypeMap>& vertices , int x , int y) = 0;
	public:
		MapBuilder( mof::TextureManager* pTextureManager , float scale , int width , int height);
		virtual ~MapBuilder(void);
		MapBuffer* create();
		float getScale();

		int getWidth(){return m_width;}
		int getHeight(){return m_height;}
	};


};