#pragma once
#include "Area.h"
#include "mof/Vector2D.h"
#include <vector>

namespace et{
	struct RegenerationEvent{
		int term;
		mof::Vector2D position;
		bool forest;
		bool earth;

		static RegenerationEvent createSleepEvent(int currentTerm ){
			RegenerationEvent event;
			event.term = currentTerm;
			event.forest = event.earth = false;
			return event;
		}

		static RegenerationEvent createForestGenEvent(int currentTerm , mof::Vector2D _position){
			RegenerationEvent event;	
			event.position = _position;
			event.forest = true;
			event.earth = false;
			event.term = currentTerm;
			return event;
		}

		bool isSleepEvent(){
			return (!forest && !earth);
		}
	};



	class World
	{
		et::AreaMap* m_pAreaMap;
		int m_regenerationLevel;
		int m_term;

		int updateAreaPowerLevel(mof::Vector2D& position , et::RegenerationEvent& event);
	public:
		World(std::vector<et::RegenerationEvent>& regenerationHistory);
		~World(void);


		et::Area& getArea(int x , int y);
		void setArea(int x , int y , et::Area& area);
		et::AreaPowerLevelMap getAreaPowerLevelMap();
		int getRegenerationLevel(){return m_regenerationLevel;}
		int getTerm(){return m_term;}
		
		int getAreaWidth(){return m_pAreaMap->getWidth();}
		int getAreaHeight(){return m_pAreaMap->getHeight();}
	};



};