#include <sqlite_wrapper.hpp>
#include <mof/ConsoleIO.hpp>
#include <mof/utilities.hpp>
#include <mof/script/ObjectData.hpp>
#include <sqlite3.h>
#include <expatJP.h>

namespace 
{
	int callback_select(void* data, int argc, char** argv, char** colnames)
	{
		mof::script::GameData* gamedata = static_cast<mof::script::GameData*>(data);
		gamedata->data_.resize(gamedata->data_.size() + 1);
		static char converted_text[512];
		for (int i = 0 ; i < argc; i++) {
			char* colname = colnames[i];	
			char* value = argv[i];	
			if (!value) throw std::runtime_error(std::string(colname) + ": null value");
			int converted_len = UTF8toSJIS(value, strlen(value), converted_text, mof::lengthOf(converted_text));
			gamedata->data_.back()[colname] = mof::tstring(converted_text, converted_len);
		}
		return 0;
	}
}

//namespace mof
//{
//namespace script
//{
//{{{ impl
	struct sqlite_wrapper::impl
	{
		sqlite3* db;

		impl()
			: db(NULL)
		{
		}
	};
//}}}
//{{{ constructor
	sqlite_wrapper::sqlite_wrapper()
		: pimpl_(new impl())
	{
		if (sqlite3_open("gamedata.db", &pimpl_->db) != SQLITE_OK) {
			throw std::runtime_error("Faild: sqlite3_open");
		}
	}
//}}}
//{{{ destructor
	sqlite_wrapper::~sqlite_wrapper()
	{
		sqlite3_close(pimpl_->db);
	}
//}}}
//{{{ query_item_data
	mof::script::GameData::ptr sqlite_wrapper::query_item_profile()
	{
		using namespace mof::script;
		GameData::ptr p = std::make_shared<GameData>();
		static const char* sql = 
			"SELECT item_profile.id, item_id, item_profile.durability, item.durability as max_durability, name, "
			"type, attached, stored, equipped, icon_type "
			"FROM item_profile, item WHERE item.id = item_profile.item_id";
		char* err;
		if (sqlite3_exec(pimpl_->db, sql, callback_select, (void*)p.get(), &err) != SQLITE_OK) {
			std::logic_error e(std::string("[") + sql + "]" + err);
			sqlite3_free(err);
			throw e;
		}
		return p;
	}
//}}}
//{{{ query_relic_data
	mof::script::GameData::ptr sqlite_wrapper::query_relic_profile()
	{
		using namespace mof::script;
		GameData::ptr p = std::make_shared<GameData>();
		static const char* sql = 
			"SELECT relic_profile.id, relic_id, num, name, icon_type "
			"FROM relic_profile, relic WHERE relic.id = relic_profile.relic_id";
		char* err;
		if (sqlite3_exec(pimpl_->db, sql, callback_select, (void*)p.get(), &err) != SQLITE_OK) {
			std::logic_error e(std::string("[") + sql + "]" + err);
			sqlite3_free(err);
			throw e;
		}
		return p;
	}
//}}}
//{{{ query_ideal_data
	mof::script::GameData::ptr sqlite_wrapper::query_ideal_profile()
	{
		using namespace mof::script;
		GameData::ptr p = std::make_shared<GameData>();
		static const char* sql = 
			"SELECT ideal_profile.id, ideal_id, name, icon_type, type, attend "
			"FROM ideal_profile, ideal WHERE ideal.id = ideal_profile.ideal_id";
		char* err;
		if (sqlite3_exec(pimpl_->db, sql, callback_select, (void*)p.get(), &err) != SQLITE_OK) {
			std::logic_error e(std::string("[") + sql + "]" + err);
			sqlite3_free(err);
			throw e;
		}
		return p;
	}
//}}}
//}// namespace script
//}// namespace mof
