#pragma once
#include <boost/scoped_ptr.hpp>
#include "mof/SceneGraph.hpp"
#include "mof/Texture.hpp"
#include "mof/Drawable.hpp"
#include "mof/Color.hpp"
#include "mof/Rectangle.hpp"

class ImageTiler : public mof::Drawable {
	struct Impl;
	boost::scoped_ptr<Impl> m_pImpl;

public:
	ImageTiler( const std::shared_ptr<mof::Texture>& pTexture );
	virtual ~ImageTiler();

	void setRegion(const mof::Rectangle<float>& region);
	void setColor(mof::Color color);
	virtual void draw() const;
	virtual void setVisible(bool visible);
};



