#pragma once
#include "mof/tstring.hpp"

namespace mof{

    struct Scene
    {
        void ( *initialize ) ();
        void ( *finalize ) ();
        void ( *update ) ();
        void ( *draw ) ();
    };


   
	namespace Application
	{
	    //private
	
		enum InputMode
		{
			INPUT_MODE_DEVICE = 0,
			INPUT_MODE_LOGGING,
			INPUT_MODE_LOGGED,
		};
	    //public
	    void initialize
	    ( 
	        const mof::tstring& appname , 
	        int width , 
	        int height ,
	        bool fullscreen ,
	        int frameInterval , 
	        int nUpdatingPerFrame,
			InputMode input_mode,
			bool enable_output_frame,
			bool enable_output_audio
	    );
	    void finalize();
	    void run( Scene& scene );
		InputMode input_mode();
	    void quit();
	}


}
