#ifndef MOF_FONT_HPP
#define MOF_FONT_HPP
#include <memory>
#include "mof/tstring.hpp"
#include "mof/PixelMap.hpp"

namespace mof{

	struct font_context
	{
		mof::Color4f font_color;	

		font_context()
			: font_color(1, 1, 1, 1)
		{
		}
	};

class Font{
	struct Impl;
	std::shared_ptr<Impl> m_pImpl;

public:
	Font(const TCHAR* fontName , size_t size);
	Font(const TCHAR* fontName , size_t size, const font_context& context);
	~Font();
	mof::tstring name() const;
	size_t size() const;
	mof::font_context context() const;

	mof::PixelMap* createText(const mof::tstring& text) const;

	static const TCHAR* MS_GOTHIC;
	static const TCHAR* MS_P_GOTHIC;
	
	static bool addFontResource(const mof::tstring& filename );
};

}



#endif
