#pragma once
#include "mof/real.hpp"
#include "mof/Color.hpp"
#include "mof/Matrix3D.hpp"
#include "mof/VertexTypes.hpp"
#include <boost/utility.hpp>
#include <boost/scoped_ptr.hpp>
#include <vector>
#include "mof/Rectangle.hpp"



namespace mof{
    struct Material;
    class Texture;

    namespace GraphicsDevice 
    {

        // public 
        
	    enum BlendingMode
	    {
		    BLENDING_MODE_ADD ,
		    BLENDING_MODE_BASIC ,
		    BLENDING_MODE_ALPHA
	    };
	
	    void setWorldTransform( const mof::Matrix3D& matrix );
	    void setProjectionTransform( real min , real max );
	    void setViewTransform( const mof::Matrix3D& matrix );
	    const mof::Matrix3D& getWorldTransform( );
	    const mof::Matrix3D& getProjectionTransform( );
	    const mof::Matrix3D& getViewTransform( );
	    void setZBuffer( bool flag );
	    void lightEnable( bool enable );
	    void clearZBuffer( );
	    void clearRenderTarget( mof::Color color );
	    void setAlphaBlendingMode( const int flag );
	    mof::Vector2D to2DPosition( const mof::Vector3D& position );
	    void setViewport( const mof::Rectangle<int>& area );
	    int getViewportWidth( );
	    int getViewportHeight( );
		int get_num_of_displays();
		std::vector<mof::Vector2D> get_caps(int adapter_id);

	    template <class T> void drawVertexArray
	    (
	        const T& front , const T& last , 
	    	mof::PRIMITIVE_TYPE type = PRIMITIVE_TYPE_TRIANGLELIST 
	    ); 
	    void setMaterial( const mof::Material& material );
	    void setTexture( const mof::Texture* pTexture );
	    mof::Rectangle<int> getClientRegion( );
	    
    } // namespace GraphicsDevice


} // namespace mof
