#ifndef MOF_MATERIAL_BUILDER_HPP
#define MOF_MATERIAL_BUILDER_HPP

#include "mof/Color.hpp"
#include <boost/scoped_ptr.hpp>
#include <boost/utility.hpp>
#include "mof/stream/Manipulator.hpp"

//struct _D3DMATERIAL9;
//typedef _D3DMATERIAL9 D3DMATERIAL9;
namespace mof{


struct Material;

class MaterialBuilder : boost::noncopyable{

	struct Impl;
	boost::scoped_ptr<Impl> m_pImpl;

public:
	MaterialBuilder();
	MaterialBuilder( mof::Color4f ambient );
	MaterialBuilder( mof::Color4f ambient , mof::Color4f diffuse , mof::Color4f specular , float power , mof::Color4f emissive );
	MaterialBuilder
	(
		const mof::Manipulator<mof::Color4f>::Handler& ambient , 
		const mof::Manipulator<mof::Color4f>::Handler& diffuse ,
		const mof::Manipulator<mof::Color4f>::Handler& specular ,
		const mof::Manipulator<float>::Handler& power ,
		const mof::Manipulator<mof::Color4f>::Handler& emissive 
	);
	~MaterialBuilder();

	void setFrameNumber(mof::FrameNumber frame);
	void nextFrame();
	void prevFrame();

	mof::Color4f getDiffuseColor() const;
	mof::Color4f getAmbientColor() const;
	mof::Color4f getSpecularColor() const;
	float getSpecularPower() const;
	mof::Color4f getEmissiveColor() const;

	const mof::Material& construct() const;
};

}

#endif 
