#ifndef MATRIX2D_HPP
#define MATRIX2D_HPP
#include <mof/real.hpp>
#include "mof/Vector2D.hpp"
#include "mof/Rectangle.hpp"
#include <memory>


namespace mof{
	class Matrix2D{
	public:
		struct Array{
			real elements[3][3];
		};
	private:
		std::shared_ptr<Array> m_pImpl;
	public:
		
		Matrix2D();
		Matrix2D(const Matrix2D& );
		explicit Matrix2D(const mof::Matrix2D::Array &);
		~Matrix2D();
		real at(int row , int column) const;
		Array getArray() const;

		static Matrix2D createIdentity();
		static Matrix2D createTransposed(Matrix2D& matrix);
		static Matrix2D createRotation(const mof::Vector2D& angle);
		static Matrix2D createTranslation(const mof::Vector2D& position);
		static Matrix2D createScaling(const mof::Vector2D& scale);
		static Vector2D getTranslation(const mof::Matrix2D& matrix);
		Vector2D getDiagonal() const;


		Matrix2D operator *(const mof::Matrix2D& matrix ) const;
		Matrix2D operator +(const mof::Matrix2D& matrix ) const;
		Matrix2D operator -(const mof::Matrix2D& matrix ) const;

		friend Vector2D operator *(const mof::Vector2D& vec , const mof::Matrix2D& matrix);
		friend Matrix2D operator *(const mof::Matrix2D& matrix , real f);
		friend Matrix2D operator *(real f ,  const mof::Matrix2D & matrix);

		mof::Rectangle<int> toBoundingBox();
	
		
	};
} // namespace mof


#endif
