#pragma once
#include "mof/stream/utilities.hpp"

namespace mof
{

    class TextureComponent
    {
    public:
        virtual ~TextureComponent( ){}

        virtual void setRectangleCoordinatesStream( const RectangleStream& stream )
        {
            m_textureStream = stream;
        }

        virtual const RectangleStream& getRectangleCoordinatesStream( ) const
        {
            return m_textureStream;
        }
        
        virtual RectangleStream& getRectangleCoordinatesStream( ) 
        {
            return m_textureStream;
        }


    protected:
        RectangleStream m_textureStream;

        TextureComponent( )
        : 
            m_textureStream( makeConstantHandler( Rectangle< real >( 0 , 0 , 1 , 1 ) ) ) 
        {
        }

        TextureComponent( const Rectangle< real >& rect )
        : 
            m_textureStream( makeConstantHandler( rect ) ) 
        {
        }

        TextureComponent( const RectangleStream& stream )
        : 
            m_textureStream( stream ) 
        {
        }

    };

} // namespace mof
