#include "mof/Window.hpp"
#include "mof/InputDevice.hpp"
#include "mof/ConsoleIO.hpp"
#include <stdexcept>

LRESULT WINAPI wndProc( HWND hWnd , UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch(msg)
	{
		case WM_ACTIVATEAPP:
			if(LOWORD(wParam) == 0)
			{
			/*	*ConsoleOut::getInstance() << "WindowANeBuɂȂ܂" << std::endl;
				mof::System::getInstance()->activate(false);
				mof::InputDevice::getInstance()->activate(false);*/
				mof::InputDevice::setActivation(false);
			}
			else 
			{
			/*	*ConsoleOut::getInstance() << "WindowANeBuɂȂ܂" << std::endl;
				mof::System::getInstance()->activate(true);
				mof::InputDevice::getInstance()->activate(true);*/
				mof::InputDevice::setActivation(true);
			}
			break;
		case WM_DESTROY:
			PostQuitMessage(0);
			break;
		case WM_SETCURSOR:
			SetCursor(NULL);
			break;
	}
	
	return DefWindowProc( hWnd, msg, wParam, lParam );
}




namespace mof
{
    
    struct Window::Impl
    {
    	mof::tstring appName;
    	HINSTANCE hInstance;
    	HWND hWindow;
	
    	Impl(const mof::tstring& appname , HINSTANCE hInstance );
    };

    Window::Impl::Impl(const mof::tstring &appname, HINSTANCE hInstance )
    : appName( appname ) , hInstance( hInstance ) , hWindow( NULL )
    {
	    // do nothing
    }   

    Window::Window( const mof::tstring &appname , int width , int height , bool fullscreen )
    : m_pImpl( new mof::Window::Impl( appname , GetModuleHandle(NULL) ) )
    {

	    // EBhENXݒ
        WNDCLASSEX wc = 
            { 
                sizeof(WNDCLASSEX), CS_CLASSDC, wndProc, 0L, 0L, 
                m_pImpl->hInstance , NULL, NULL, NULL, NULL,
                m_pImpl->appName.c_str()  , NULL
            };
        RegisterClassEx( &wc );

	    // EBhE
	    if( !fullscreen )
	    {
	    	// w肳ꂽNCAg̈mۂ邽߂ɕKvȃEBhETCY𓾂
	    	RECT rect_win;
	    	SetRect( &rect_win , 0 , 0 , width , height );
	    	AdjustWindowRect( &rect_win , WS_OVERLAPPEDWINDOW , false );
            
	    	//Window[h
	        m_pImpl->hWindow = 
	            CreateWindow
	            ( 
	                 m_pImpl->appName.c_str() , m_pImpl->appName.c_str() , 
	                 WS_OVERLAPPEDWINDOW , CW_USEDEFAULT, CW_USEDEFAULT, (rect_win.right - rect_win.left) ,
	                 (rect_win.bottom - rect_win.top) , GetDesktopWindow() , NULL , wc.hInstance , NULL
	            );
	    }
    	else
    	{
		    //tXN[
		    m_pImpl->hWindow = 
		        CreateWindow
		        (
		            m_pImpl->appName.c_str() , m_pImpl->appName.c_str() , 
		    	    WS_VISIBLE , CW_USEDEFAULT , CW_USEDEFAULT , width , height ,
		        	HWND_DESKTOP , NULL , wc.hInstance , NULL
		        );
	    }
	
	 
	    // EBhE`
        ShowWindow( m_pImpl->hWindow , SW_SHOWDEFAULT );
        UpdateWindow( m_pImpl->hWindow );


    } // function constructor 



    Window::~Window( )
    {
	    try
	    {
	    	
	    	//OȂH
	    	UnregisterClass(m_pImpl->appName.c_str() , m_pImpl->hInstance );
	    }
	    catch(...)
	    {
	    }
	
    }
    
    HWND Window::getHandler() const {
        return m_pImpl->hWindow;
    }

} // namespace mof