#ifndef MOF_MESH_HPP
#define MOF_MESH_HPP
#include <d3d9.h>
#include "mof/Graphics3D.hpp"
#include <boost/scoped_ptr.hpp>
#include "mof/Material.hpp"
#include "mof/Texture.hpp"

namespace mof{

struct MeshDisposer;

class Mesh : public Graphics3D 
{
	struct Impl;
	boost::scoped_ptr<Impl> m_pImpl;

public :
	Mesh(
		std::shared_ptr<mof::MeshDisposer> pMeshDisposer ,
		unsigned long nMaterials ,
		const std::shared_ptr<mof::Material>* pMaterials , 
		const std::shared_ptr<mof::Texture>* pTextures );
	virtual ~Mesh();

	virtual void setWorldMatrix(const mof::Manipulator<mof::Matrix3D>::Handler& handler);
	virtual void setTexture( 
		unsigned int num ,
		const std::shared_ptr<mof::Texture>& pTexture);

	virtual bool isVisible() const;
	virtual void update();
	virtual void draw() const;
	//virtual bool isDisposable() const;

};

}

#endif
