#pragma once
#include <memory>
#include <mof/tstring.hpp>

namespace mof
{
namespace script
{
	class CommandSet;

	class LuaInterpreter
	{
	public:
		LuaInterpreter(const mof::tstring& filename);
		virtual ~LuaInterpreter();
		virtual void start(const mof::tstring& entry_function);
		virtual void update();
		static void bind(std::shared_ptr<CommandSet> commands);
	private:
		struct Impl;
		std::unique_ptr<Impl> impl_;	
	};

}// namespace script
}// namespace mof
