#pragma once
#include <memory>
#include <vector>
#include <list>
#include <map>
#include <mof/tstring.hpp>
#include <mof/Board.hpp>
#include <mof/particlegen.hpp>
#include <mof/stream/ReferenceWrapper.hpp>

namespace mof
{
	class Sprite;
	class particlegen;
namespace widget
{
	class Message;
	class Menu;
	class Frame;
}
	class SoundBuffer;

namespace script
{

		struct MessageData
		{
			std::shared_ptr<mof::widget::Message> message_;
			std::shared_ptr<mof::widget::Frame> frame_;// Drawer
		};
		
		struct MenuData
		{
			std::shared_ptr<mof::widget::Menu> menu_;
			std::shared_ptr<mof::widget::Frame> frame_;// Drawer

		};

		struct PictureData
		{
			std::shared_ptr<mof::Sprite> sprite_;
			typedef std::shared_ptr<PictureData> ptr;
		};
		
		struct ParticlegenData
		{
			mof::particlegen::ptr particlegen_;
			ReferenceWrapper<Matrix3D> position_ref_;
			typedef std::shared_ptr<ParticlegenData> ptr;
		};


		struct SoundData
		{
			std::shared_ptr<mof::SoundBuffer> sound_;
			bool streaming_;
		};

		struct GameData // TODO rename
		{
			std::vector<std::map<mof::tstring, mof::tstring>> data_;
			typedef std::shared_ptr<GameData> ptr;
			typedef std::map<mof::tstring, mof::tstring> entry_t;
			typedef std::pair<mof::tstring, mof::tstring> pair_t;

			friend std::ostream& operator <<(std::ostream& os , const GameData& obj);
		};


}// namespace script
}// namespace mof
