#include <memory>
#include <algorithm>
#include <mof/widget/NullView.hpp>
#include <mof/widget/Message.hpp>
#include <mof/widget/AbstractTextCompiler.hpp>
#include <mof/widget/Page.hpp>
#include <mof/widget/Pager.hpp>
#include <mof/widget/WidgetView.hpp>
#include <mof/ConsoleIO.hpp>
//#include <queue>

namespace mof
{
namespace widget
{
//{{{ MessageView
	class MessageView : public WidgetView
	{
		std::shared_ptr<mof::widget::WidgetView> view_;
		std::shared_ptr<mof::widget::WidgetView> old_view_;
		mof::Vector2D region_;
		//const mof::Vector2D& region_; なんでconstやったん？
		bool visible_;
	public:

		MessageView(const mof::Vector2D& region)
			: region_(region), visible_(true)
		{
			view_ = std::make_shared<mof::widget::NullView>();
			view_->getPositionStream() << getPositionStream();
			view_->getSizeStream() << getSizeStream();//TODO regionを入れる？
			view_->getColorStream() << getColorStream();
		}

		~MessageView()
		{

		}

		FrameNumber show(bool imidiately)
		{
			
			return view_->show(imidiately);
		}
		
		FrameNumber hide(bool imidiately)
		{
			return view_->hide(imidiately);
		}

		FrameNumber focus(bool imidiately)
		{
			return show(imidiately);
		}
		
		FrameNumber blur(bool imidiately)
		{
			return hide(imidiately);
		}
		
		FrameNumber click(bool)
		{
			return 0;
		}
		
		void update()
		{
			getPositionStream().update();
			getSizeStream().update();
			getColorStream().update();
			if (old_view_.get()) old_view_->update();
			view_->update();
		}
		
		void draw() const
		{
			if (old_view_.get()) old_view_->draw();
			view_->draw();
		}

		void setVisible(bool visible)
		{
			visible_ = visible;
			if (old_view_.get()) old_view_->setVisible(visible);
			if (view_.get()) view_->setVisible(visible);
		}

		mof::Vector2D getPreferredSize() const
		{
			return region_;
		}

		FrameNumber swap(std::shared_ptr<mof::widget::WidgetView> view)
		{
			old_view_ = view_;
			view_ = view;
			view_->setVisible(visible_);
			FrameNumber period = view_->show();
			period = max(period, old_view_->hide());

			view_->getPositionStream() << getPositionStream();
			view_->getSizeStream() << view_->getSizeStream().value() << getSizeStream();
			view_->getColorStream() << getColorStream();
			return period;
		}

	
	};
//}}}
//{{{ Impl
    struct Message::Impl
    {
        std::shared_ptr<AbstractTextCompiler> pCompiler;
        std::shared_ptr<Pager> pPager;
		std::shared_ptr<MessageView> view_;
      
        Impl(const mof::Vector2D& region, const std::shared_ptr<AbstractTextCompiler>& pCompiler)
        : pCompiler(pCompiler), pPager(new Pager), view_(new MessageView(region))
        {
        }
    };
//}}}
//{{{ constructor
    Message::Message(const mof::Vector2D& region, const std::shared_ptr<AbstractTextCompiler>& pCompiler)
    : pImpl_(new Impl(region, pCompiler))
    {
    }
//}}}
//{{{ destructor
    Message::~Message()
    {
    }
//}}}
//{{{ show
    mof::FrameNumber Message::show(bool imidiately)
    {
        //return pImpl_->pPager->show();
        return 0;
    }
//}}}
//{{{ hide
    mof::FrameNumber Message::hide(bool imidiately)
    {
        //return pImpl_->pPager->hide();
        return 0;
    }
//}}}
//{{{ getView
    const std::shared_ptr<mof::widget::WidgetView> Message::getView() const
    {
		return pImpl_->view_;
    }
//}}}
//{{{ getView
    std::shared_ptr<mof::widget::WidgetView> Message::getView() 
    {
		return pImpl_->view_;
    }
//}}}
//{{{ update 
    void Message::update() 
    {
		return pImpl_->view_->update();
    }
//}}}
//{{{  addPage
    void Message::addPage(const tstring& page) 
    {
        pImpl_->pPager->addPage( *pImpl_->pCompiler->compile(page) );
    }
//}}}
//{{{ nextPage
    FrameNumber Message::nextPage() 
    {
        pImpl_->pPager->next();
		return pImpl_->view_->swap(pImpl_->pPager->getPage().view());
    }
//}}}

}// namespace widget
}// mof
