#pragma once
#include <mof/widget/WidgetView.hpp>
#include <mof/widget/Widget.hpp>
#include <mof/widget/Effect.hpp>
#include <mof/stream/Manipulator.hpp>
#include <boost/utility.hpp>
#include <memory>

namespace mof
{
namespace widget
{
    class AbstractTextCompiler;


	class Message : public Widget
    {
	public:
        Message(const mof::Vector2D& region, const std::shared_ptr<AbstractTextCompiler>& pCompiler);
		virtual ~Message();
		virtual FrameNumber show(bool imidiately = false);
		virtual FrameNumber hide(bool imidiately = false);
        virtual const std::shared_ptr<WidgetView> getView() const;
        virtual std::shared_ptr<WidgetView> getView();
		virtual void update();

        void addPage(const tstring& page);
        FrameNumber nextPage();
		//void setPageShowAction(std::shared_ptr<mof::Vector2D> position, std::shared_ptr<mof::Vector2D> size, std::shared_ptr<mof::Vector2D> color);
    private:
        struct Impl;
		std::unique_ptr<Impl> pImpl_;
	}; 

}
}
