#include <mof/widget/WidgetView.hpp>
#include <mof/widget/Pager.hpp>
#include <deque>
#include <memory>
#include <mof/widget/NullView.hpp>
#include <mof/utilities.hpp>

namespace mof
{
namespace widget
{
   struct Pager::Impl
   {
       std::deque<Page> pageQueue; 

       Impl()
	   {
		   pageQueue.push_back(Page(std::make_shared<NullView>(), ""));
	   }

       ~Impl(){}
   };

//{{{ constructor
   Pager::Pager()
   : pImpl_(new Impl)
   {
   }
//}}}
//{{{ destructor
   Pager::~Pager()
   {
   }
//}}}
//{{{ getPage
   const Page& Pager::getPage() const
   {
		return pImpl_->pageQueue.front();
   }
//}}}
//{{{ getPage
   Page& Pager::getPage()
   {
		return pImpl_->pageQueue.front();
   }
//}}}
//{{{ addPage
   void Pager::addPage( const Page& page )
   {
       pImpl_->pageQueue.push_back(page);
   }
//}}}
//{{{ next
   void Pager::next()
   {
       pImpl_->pageQueue.pop_front();
   }
//}}}
//{{{ size
   size_t Pager::size() const
   {
       return pImpl_->pageQueue.size();
   }
//}}}

}// namespace widget
}// namespace mof

