#pragma once
#include <mof/Color.hpp>
#include <mof/Rectangle.hpp>
#include <memory>
#include <boost/variant.hpp>
#include <mof/widget/flow_layout.hpp>

namespace mof
{
namespace widget
{
	class mofml_parser
	{
	public:
//{{{ text_node
		struct text_node
		{
			mof::Color4f font_color;
			mof::tstring text;
			text_node() {}// do nothing
		};
//}}}
//{{{ image_node
		struct image_node
		{
			mof::tstring src;
			float width, height;
			Rectangle<float> t_rect;
			image_node() : width(0), height(0) {}// do nothing
		};
//}}}
//{{{ new_line_node
		struct new_line_node{};
//}}}
//{{{ end_node
		struct end_node{};
//}}}
//{{{ layout_start_node
		struct layout_start_node{};
//}}}
//{{{ layout_end_node
		struct layout_end_node
		{
			size_t width, height;
			flow_layout::xalign xalign;
			flow_layout::yalign yalign;

			layout_end_node() 
				: width(0), height(0), 
				xalign(flow_layout::XALIGN_LEFT),
				yalign(flow_layout::YALIGN_TOP)
			{}// do nothing
		};
//}}}
		typedef boost::variant<text_node, image_node, new_line_node, end_node, layout_start_node, layout_end_node> node;
		enum node_type
		{
			TEXT = 0, IMAGE, NEW_LINE, END, LAYOUT_START, LAYOUT_END
		};

		mofml_parser();
		~mofml_parser();

		void set_text(const mof::tstring& text);
		node next_node();	
		bool has_next_node() const;

	private:
		struct impl;
		std::unique_ptr<impl> pimpl_;
	};
}// namespace widget
}// namespace mof
