#pragma once
#include <mof/math/basic_vector.hpp>
#include <mof/math/vector2.hpp>

namespace mof
{
namespace math
{
	/**
	 * @brief 3次元同次座標ベクトルクラス
	 */
	class vector3 : public basic_vector<3, vector3>
	{
	public:
//{{{ constructor
		/**
		 * @brief デフォルトコンストラクタ．
		 * @note  効率のためは初期化されない
		 */
		vector3()
		{
		}

		/**
		 * @brief 指定した値で初期化する．
		 * @param[in] x x座標成分
		 * @param[in] y y座標成分
		 * @param[in] z z座標成分
		 */
		vector3(float x, float y, float z)
		{
			components_[0] = x;
			components_[1] = y; 
			components_[2] = z;
		}

		/**
		 * @brief 指定した値で初期化する．
		 * @tparam    T   配列型（operator[]をオーバーロードしていること）
		 * @param[in] arr 初期化用配列
		 */
		template <class T>
		vector3(const T& arr)
		{
			components_[0] = arr[0];
			components_[1] = arr[1];
			components_[2] = arr[2];
		}

//}}}
//{{{ accesser
		float x() const { return components_[0]; }
		float y() const { return components_[1]; }
		float z() const { return components_[2]; }
		float w() const { return 1; }// 第4要素は常に1
//}}}
	};

}// namespace math
}// namespace mof
