require('script/strict')
--[eBeB֐
--{{{ is_empty
function is_empty(str)
	if str == nil or str == '' then return true
	else return false end
end
--}}}
--{{{ split
function split(str, delim)
	if string.find(str, delim) == nil then
		return {str}
	end

	local result = {}
	local pat = '(.-)' .. delim .. '()'
	local last_pos
	for part, pos in string.gfind(str, pat) do
		table.insert(result, part)
		last_pos = pos
	end
	table.insert(result, string.sub(str, last_pos))
	return unpack(result)
end
--}}}
--{{{ join
function join(tbl, sep)
	local ret
	for n, v in pairs(tbl) do
		local seg = tostring(v)
		if ret == nil then
			ret = seg
		else
			ret = ret .. sep .. seg
		end
	end
	return ret
end
--}}}
--{{{ find
function find(tbl, elem)
	if tbl == nil then return false end

	for n, v in pairs(tbl) do
		if v == elem then return true end
	end
	return false
end
--}}}
--{{{ layout
function layout(left_margin, width, right_margin, top_margin, height, bottom_margin)
	-- TODO get from app
	local data = load_game_data('system.client_region')
	local screen_width = data[1]['width'] 
	local screen_height = data[1]['height']

	local x, y --results

	-- TODO parameter check. use error function
	if left_margin ~= nil and right_margin ~= nil then
		-- Ẽ}[W璆Sʒu߂
		local center_from_left = left_margin + (1.0 - left_margin - right_margin) / 2
		x = center_from_left * screen_width - width / 2
	end
	
	if top_margin ~= nil and bottom_margin ~= nil then
		-- ㉺̃}[W璆Sʒu߂
		local center_from_top = top_margin + (1.0 - top_margin - bottom_margin) / 2
		y = center_from_top * screen_height - height / 2
	end



	return x, y;
end
--}}}
--moflib API
--{{{ waitFrame
function wait_frame(frame)
	waitFrameImpl(frame)
	coroutine.yield()
end

--̃L[萔InputReceiverƓĂȂ΂ȂȂ
KEY_UP    = 1
KEY_DOWN  = 2
KEY_LEFT  = 3
KEY_RIGHT  = 4
KEY_A      = 5
KEY_B      = 6
KEY_C      = 7
KEY_D      = 8
KEY_E      = 9
KEY_F      = 10
KEY_G      = 11
KEY_H      = 12
KEY_I      = 13
KEY_J      = 14
KEY_K      = 15
KEY_L      = 16
KEY_M      = 17
KEY_N      = 18
KEY_O      = 19
KEY_P      = 20
KEY_Q      = 21
KEY_R      = 22
KEY_S      = 23
KEY_T      = 24
KEY_U      = 25
KEY_V      = 26
KEY_W      = 27
KEY_X      = 28
KEY_Y      = 29
KEY_Z      = 30
KEY_ESCAPE = 31 
KEY_ANY    = 32
--}}}
--{{{ sound
function sound(filepath)
	local id = soundCreateImpl(filepath)
	soundPlayImpl(id)
	--disposeImpl(id, 'sound')
end
--}}}
--{{{ load_game_data
function load_game_data(resource_path)
	return loadGameDataImpl(resource_path)
end
--}}}
--{{{ wait_for_key
function wait_for_key(key)
	waitForKeyImpl(key)
	coroutine.yield()
end
--}}}
--{{{ get_last_key
function get_last_key()
	return getLastKeyImpl()
end
--}}}
--{{{ get_key
function get_key()
	wait_for_key(KEY_ANY)
	return get_last_key()
end
--}}}
--{{{ message
function message(title, texts, style, initializer)
	local obj = Message:new(title)
	if initializer ~= nil then initializer(obj) end
	local frame = obj:show()
	--wait_frame(frame)
	for i = 1 , #texts , 1  
	do
		local frame = obj:next(texts[i])
		wait_frame(frame)
		wait_for_key(KEY_Z)
	end 
	local frame = obj:hide()
	wait_frame(frame)
	obj:dispose()
end
--{{{ new
Message = {}
function Message:new(title, style)
	if style == nil then style = '' end
	local id = messageNewImpl(title, style)
	local obj = {}
	obj.id_ = id
	setmetatable(obj, {__index = Message})
	return obj
end
--}}}
--{{{ show
function Message:show()
	return showImpl(self.id_, 'message')
end
--}}}
--{{{ hide
function Message:hide()
	return hideImpl(self.id_, 'message')
end
--}}}
--{{{ set_tween
function Message:set_tween(target, stream, period)
	if period == nil then period = 0 end
	objectSetBehaviorImpl(self.id_, 'message.' .. target, stream, period)
end
--}}}
--{{{ get_property
function Message:get_properties()
	return objectGetPropertiesImpl(self.id_, 'message')
end
--}}}
--{{{ next
function Message:next(text)
	print_debug(text)
	return messageNextImpl(self.id_, text)
end
--}}}
--{{{ dispose
function Message:dispose(text)
	return disposeImpl(self.id_, 'message')
end
--}}}
--}}}
--{{{ question
function question(title, items, style, disables, initializer)
	if disables ~= nil then 
		-- disablew肳Ăstyleɒǉ
		if not is_empty(style) then style = style .. ';' end
		style = 'disable=' .. join(disables, ',')
	end
	local obj = Question:new(title, items, style)
	if initializer ~= nil then initializer(obj) end
	local frame = obj:show()
	wait_frame(frame)
	while true do
		local key = get_key()
		if key == KEY_UP then obj:move_cursor_up()
		elseif key == KEY_DOWN then obj:move_cursor_down()
		elseif key == KEY_LEFT then obj:move_cursor_left()
		elseif key == KEY_RIGHT then obj:move_cursor_right()
		elseif key == KEY_X then 
			sound("sound/cancel.wav")-- LZ
			frame = obj:hide()
			wait_frame(frame)
			obj:dispose()
			return 0 --LZ
		elseif key == KEY_Z then 
			local index = obj:get_current()
			if not find(disables, index) then -- disableȂ疳
				sound("sound/decide.wav")-- 艹
				frame = obj:select()
				wait_frame(frame)
				frame = obj:hide()
				wait_frame(frame)
				obj:dispose()
				return index + 1 --0 ̓LZ̓
			end
		end	
	end
end
--{{{ new
Question = {}
function Question:new(title, items, style)
	if style == nil then style = '' end
	local id = menuNewImpl(title, items, style)
	local obj = {}
	obj.id_ = id
	setmetatable(obj, {__index = Question})
	return obj
end
--}}}
--{{{ show
function Question:show()
	return showImpl(self.id_, 'menu')
end
--}}}
--{{{ hide
function Question:hide()
	return hideImpl(self.id_, 'menu')
end
--}}}
--{{{ set_tween
function Question:set_tween(target, stream, period)
	if period == nil then period = 0 end
	objectSetBehaviorImpl(self.id_, 'menu.' .. target, stream, period)
end
--}}}
--{{{ get_property
function Question:get_properties()
	return objectGetPropertiesImpl(self.id_, 'menu')
end
--}}}
--{{{ move_cursor
MOVE_UP    = 0
MOVE_DOWN  = 1
MOVE_LEFT  = 2
MOVE_RIGHT = 3

function Question:move_cursor_up()
	return menuMoveCursorImpl(self.id_, MOVE_UP)
end

function Question:move_cursor_down()
	return menuMoveCursorImpl(self.id_, MOVE_DOWN)
end

function Question:move_cursor_left()
	return menuMoveCursorImpl(self.id_, MOVE_LEFT)
end

function Question:move_cursor_right()
	return menuMoveCursorImpl(self.id_, MOVE_RIGHT)
end
--}}}
--{{{ get_currnet
function Question:get_current()
	return menuGetCurrentImpl(self.id_)
end
--}}}
--{{{ select
function Question:select()
	return menuSelectImpl(self.id_)
end
--}}}
--{{{ dispose
function Question:dispose()
	return disposeImpl(self.id_, 'menu')
end
--}}}
--}}}
--{{{ print_debug
function print_debug(obj, spacer)
	if (type(obj) ~= 'table') then
		printDebugImpl(tostring(obj))
		return
	end

	if spacer == nil then spacer = '' end

	for key, value in pairs(obj) do  
		if (type(value) ~= 'table') then
			printDebugImpl(spacer .. tostring(key) .. ' => ' .. tostring(value))
		else
			printDebugImpl(spacer .. tostring(key) .. ' => ' )
			print_debug(value, spacer .. '  ')
		end
	end
end
--}}}
--{{{ picture
--{{{ new
Picture = {}
function Picture:new(path)
	local id = pictureCreateImpl(path)
	local obj = {}
	obj.id_ = id
	setmetatable(obj, {__index = Picture})
	return obj
end
--}}}
--{{{ set_tween
function Picture:set_tween(target, stream)
	objectSetBehaviorImpl(self.id_, 'picture.' .. target, stream, 0)
end
--}}}
--{{{ dispose
function Picture:dispose()
	return disposeImpl(self.id_, 'picture')
end
--}}}
--}}}
--{{{ particlegen
--{{{ new
Particlegen = {}
function Particlegen:new()
	local id = particlegenCreateImpl()
	local obj = {}
	obj.id_ = id
	setmetatable(obj, {__index = Particlegen})
	return obj
end
--}}}
--{{{ set_tween
function Particlegen:set_tween(target, stream)
	objectSetBehaviorImpl(self.id_, 'particlegen.' .. target, stream, 0)
end
--}}}
--{{{ dispose
function Particlegen:dispose()
	return disposeImpl(self.id_, 'particlegen')
end
--}}}
--}}}
