#pragma once
#include "mof/GeneralMap.h"

namespace et{
	struct AreaPowerLevel
	{
		int forest;
		int earth;

		AreaPowerLevel(){
			forest = earth = 0;
		}

		AreaPowerLevel(int _forest , int _earth){
			forest = _forest;
			_earth = earth;
		}
	};

	typedef mof::GeneralMap<et::AreaPowerLevel> AreaPowerLevelMap;

	

	struct Area{
		AreaPowerLevel powerLevel;
		bool forestGen;
		bool earthGen;
		bool town;

	public :
		Area(){
			forestGen = earthGen = false;
			town = false;
		}
		
		bool hasSomethingIcon(){
			return (forestGen || earthGen || town);
		}
	};

	typedef mof::GeneralMap<et::Area> AreaMap;


	
};