#include "BattlerBindAnimation.h"
#include "mof/GraphicsDevice.h"


et::BattlerBindAnimation::BattlerBindAnimation(et::BattlerFacade* pBattler)
{
	m_finalKey = 0;
	m_key = 0;
	m_pBattler = pBattler;
}

et::BattlerBindAnimation::~BattlerBindAnimation(void)
{
}


mof::Vector2D et::BattlerBindAnimation::getPosition(){
	if(!isPlaying())return mof::Vector2D(0 , -100);
	return mof::GraphicsDevice::getInstance()->to2DPosition(m_pBattler->getPosition());
}

mof::Color et::BattlerBindAnimation::getColor(){
	return mof::createColor( 255 , 255 , 255);
}

bool et::BattlerBindAnimation::update(){
	if(!isPlaying())return false;
	m_key++;
	//if(isFinalized() && isLooping())m_key = 0;
	if(isFinalized())stop();
	return true;
}

		
bool et::BattlerBindAnimation::isFinalized(){
	if(m_key > m_finalKey)return true;
	return false;
}


void et::BattlerBindAnimation::setFinalKey(mof::AnimationKey key){
	m_finalKey = key;
}