#pragma once
#include "mof/Graphics.h"
#include "mof/Billboard.h"
#include "BattlerParameter.h"
#include "Action.h"
#include "BattlerType.h"
#include "mof/DataTable.h"

namespace et{
	class BattlerGroup;
	class BattlerFacade
	{
	public:
		/*enum BattlerType{
			ENEMY , HERO , IDEAL
		};*/
	private:
		BattlerType m_type;
		BattlerParameter m_parameter;
		int m_timeStamp;
		mof::Vector3D m_basePosition;
	protected:
		mof::Billboard* m_pGraphicsObject;
	public:

		BattlerFacade(BattlerType m_type );
		
		virtual ~BattlerFacade(void);
		mof::Billboard* getGraphicsObject();
		const BattlerParameter& getParameter(){return m_parameter;}
		void setParameter(const BattlerParameter& parameter){m_parameter = parameter;m_timeStamp++;}
		BattlerType getType(){return m_type;}

		mof::Vector3D getPosition();
		virtual mof::AnimationResource setMovingAnimation(mof::Vector3D& goal , int nFrame) = 0;
		virtual mof::AnimationResource setAidlingAnimation(mof::Vector3D& position) = 0;
		virtual mof::AnimationResource setCastAnimation(int category) = 0;
		virtual mof::AnimationResource setDamagedAnimation(int level) = 0;
		virtual Action* createAction(BattlerGroup* pGroup ) = 0;
		int getTimeStamp();
		void setBasePosition(mof::Vector3D& position){m_basePosition = position;}
		mof::Vector3D& getBasePosition(){return m_basePosition;}
	};


}