#include "DungeonBuilder.h"
#include "mof/SoftVertexBufferImpl.h"
#include "mof/HardVertexBufferImpl.h"


et::DungeonBuilder::DungeonBuilder(mof::PixelMap& map , mof::TextureManager* pTextureManager , float scale)
: MapBuilder(pTextureManager , scale , map.getWidth() , map.getHeight() ) , m_map(map) 
{
	m_blockWidth = map.getWidth();
	m_blockHeight = map.getHeight();
}

et::DungeonBuilder::~DungeonBuilder(void)
{
}

void et::DungeonBuilder::setBlockSize(int width , int height){
	m_blockWidth = width;
	m_blockHeight = height;
}



et::DungeonBuffer* et::DungeonBuilder::createBlock(int _x , int _y){

	int beginX = _x * m_blockWidth;
	int endX = (_x+1) * m_blockWidth;
	if(endX > m_map.getWidth())endX = m_map.getWidth();
	int beginY = _y * m_blockHeight;
	int endY = (_y+1) * m_blockHeight;
	if(endY > m_map.getHeight())endY = m_map.getHeight();

	std::vector<et::VertexTypeDungeon> vertices;
	
	for(int x = beginX ; x < endX ; x++){
		for(int y = beginY ; y < endY ; y++){
			addParts(vertices , x , y);
		}
	}

	return new mof::SoftVertexBuffer<et::VertexTypeDungeon>(et::DungeonBuffer::PRIMITIVE_TYPE_TRIANGLELIST , vertices);
}


