#include "Symbol.h"
#include <iostream>
#include "mof/KeyFrameAnimation.h"
#include "mof/ConsoleIO.h"


et::Symbol::Symbol(mof::Component3D* pBody , float scale)
: mof::Component3D()
{
	m_pBody = pBody;
	m_nextRunningKey = 0;
	setDirection(et::Symbol::DOWN);
	m_scale = mof::Vector3D(scale , scale , scale);
	
	mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation(true);
	pAnimation->setScale(0 , m_scale);
	setAnimation(0 , mof::AnimationResource(pAnimation));
	
}



et::Symbol::Symbol(mof::Component3D* pBody , mof::Vector3D& scale)
: mof::Component3D()
{
	m_pBody = pBody;
	m_nextRunningKey = 0;
	setDirection(et::Symbol::DOWN);
	m_scale = scale;
	
	mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation(true);
	pAnimation->setScale(0 , mof::Vector3D(scale.x , scale.y , scale.z));
	setAnimation(0 , mof::AnimationResource(pAnimation));
}


et::Symbol::~Symbol(void)
{
	delete m_pBody;
}


/*
void et::Symbol::move(et::Symbol::Direction direction , float span , int length){
	m_direction = direction;
	mof::AnimationResource pAnimation = getAnimation(2);
	if(pAnimation.get() != NULL && !pAnimation->isFinalized())return;
	

	const float SPEED_X = span;
	const float SPEED_Y = span;
	const float tableX[] = {0.0f , 0.0f , -SPEED_X , SPEED_X};
	const float tableZ[] = {SPEED_Y , -SPEED_Y , 0.0f , 0.0f};

	mof::KeyFrameAnimation* pKeyFrameAnimation = new mof::KeyFrameAnimation();
	pKeyFrameAnimation->setVelocity(0 , mof::Vector3D(tableX[direction] , 0.0f , tableZ[direction] ));
	pKeyFrameAnimation->setVelocity(length ,mof::Vector3D( 0.0f , 0.0f , 0.0f));


	

	setAnimation(3 , mof::AnimationResource(pKeyFrameAnimation));
	

}*/



void et::Symbol::move(Direction direction ,  mof::Vector3D& position , int length)
{
	m_direction = direction;
	mof::AnimationResource pAnimation = getAnimation(3);
	if(pAnimation.get() != NULL && !pAnimation->isFinalized())return;
	
	mof::Vector3D current = getPosition();
	mof::KeyFrameAnimation* pKeyFrameAnimation = new mof::KeyFrameAnimation();
	pKeyFrameAnimation->setPosition(0 , current);
	pKeyFrameAnimation->setPosition(length , position);
	pKeyFrameAnimation->update();//̍XVňړ

	setAnimation( 3 , mof::AnimationResource(pKeyFrameAnimation));
	
	pKeyFrameAnimation = new mof::KeyFrameAnimation();

	const int tableRunningY[] = {3 , 2 , 1 , 2 , 3 , 3 , 2 , 1 , 2 , 3};
	const int tableRunningX[] = {0 , 0 , 0 , 0 , 0 , 1 , 1 , 1 , 1 , 1};
	const int lengthOfRunning = 10;
	for(int i = 0 ; i < 1 ; i++){
		int key = (m_nextRunningKey + i) % lengthOfRunning;
		mof::Vector2D begin(32 * direction + 128 * tableRunningX[key] , tableRunningY[key] * 64 );
		mof::Vector2D end(32 * (direction+1) + 128 * tableRunningX[key] ,  (tableRunningY[key]+1) * 64 );
		pKeyFrameAnimation->setTextureRectangle(i*6 , mof::Line2D(begin , end));
	}
	m_nextRunningKey = (m_nextRunningKey + 1) % lengthOfRunning;

	pKeyFrameAnimation->setTextureRectangle(length+1 , mof::Line2D(32 * direction , 0 , 32 * (direction+1) , 64));
	pKeyFrameAnimation->setFinalKey(length);

	setAnimation( 2 , mof::AnimationResource(pKeyFrameAnimation));
	

}

bool et::Symbol::update(){
	
	return m_pBody->update();

}

bool et::Symbol::draw(){
	return m_pBody->draw(m_worldTransform);
}

bool et::Symbol::draw(mof::Matrix3D& transform){
	return m_pBody->draw(m_worldTransform * transform);
}



void et::Symbol::setAnimation(int index , mof::AnimationResource& pAnimation){
	mof::GraphicsObject::setAnimation(index , pAnimation);
	m_pBody->setAnimation(index , pAnimation);
	
}

void et::Symbol::setWorldTransform(mof::Matrix3D& matrix){
	m_pBody->setWorldTransform( matrix);
}
	

mof::Vector3D et::Symbol::getPosition(){
	return m_pBody->getPosition();
}

/*
void et::Symbol::setPosition(mof::Vector3D& position){
	m_pBody->setPosition(position);
}*/

void et::Symbol::setPosition(mof::Vector3D& position , et::Symbol::Direction direction){
	
	setDirection(direction);
	mof::Vector3D current = getPosition();
	mof::KeyFrameAnimation* pKeyFrameAnimation = new mof::KeyFrameAnimation();
	pKeyFrameAnimation->setPosition(0 , position);
	setAnimation( 3 , mof::AnimationResource(pKeyFrameAnimation));
	
}


et::Symbol::Direction et::Symbol::getDirection(){
	return m_direction;
}

void et::Symbol::setDirection(et::Symbol::Direction direction){
	mof::KeyFrameAnimation* pKeyFrameAnimation = new mof::KeyFrameAnimation();
	pKeyFrameAnimation->setTextureRectangle(0 , mof::Line2D(32 * direction , 0 , 32 * (direction+1) , 64));
	setAnimation(2 , mof::AnimationResource(pKeyFrameAnimation));
	m_direction = direction;

}

mof::Vector3D& et::Symbol::getScale(){
	return m_scale;
}


