#pragma once
#include "mof/Component3D.h"

namespace et{
	class Symbol : public mof::Component3D
	{
	public:
		typedef enum{
			UP = 0,
			DOWN , LEFT , RIGHT
		} Direction;
	protected:
		Component3D* m_pBody;
		int m_nextRunningKey;
		Direction m_direction;
		mof::Vector3D m_scale;
		//bodyAnimationL
	
	public:
		Symbol(Component3D* pBody , float scale);
		Symbol(Component3D* pBody , mof::Vector3D& scale);
		virtual ~Symbol(void);

		//void move(Direction direction , float span , int length);//span--1t[̈ړ length--t[
		void move(Direction direction ,  mof::Vector3D& position , int length);

		virtual bool update();
		virtual bool draw();
		virtual bool draw(mof::Matrix3D& transform);
		virtual void setAnimation(int index , mof::AnimationResource& pAnimation);
		virtual void setWorldTransform(mof::Matrix3D& matrix);
		virtual mof::Vector3D getPosition();
		//virtual void setPosition(mof::Vector3D& position);
		virtual void setPosition(mof::Vector3D& position , Direction direction);
		mof::Vector3D& getScale();
		Direction getDirection();
		void setDirection(Direction direction);


		
		

	};


};