#pragma once
#include <mof/FactoryMethod.hpp>
#include <mof/widget/MenuWidget.hpp>
#include <mof/graphics/utilities.hpp>
#include <mof/widget/utilities.hpp>
#include <boost/scoped_ptr.hpp>
#include <mof/widget/Widget.hpp>

	

class SystemMenuWidget : public mof::MenuWidget
{
public:
	SystemMenuWidget(const mof::MenuItem& front , const mof::MenuItem& back);
	virtual ~SystemMenuWidget();
	virtual mof::FrameNumber show(bool imidiately);
	virtual mof::FrameNumber hide(bool imidiately);
    virtual const mof::WidgetView& getView() const;
    virtual mof::WidgetView& getView();
	virtual void update();
    
    virtual void up();
	virtual void down();
	virtual void left();
	virtual void right();
	virtual void performAction() const;

private:
    struct Impl;
    boost::scoped_ptr<Impl> m_pImpl;
};

